/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import org.dellroad.stuff.vaadin7.BackedProperty;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;
import org.dellroad.stuff.vaadin7.ReadOnlyProperty;

public class SimpleProperty<T, V>
extends ReadOnlyProperty<V>
implements BackedProperty<T, V> {
    private final T object;
    private final PropertyDef<V> propertyDef;
    private final PropertyExtractor<? super T> propertyExtractor;

    public SimpleProperty(T object, PropertyDef<V> propertyDef, PropertyExtractor<? super T> propertyExtractor) {
        if (object == null) {
            throw new IllegalArgumentException("null object");
        }
        if (propertyDef == null) {
            throw new IllegalArgumentException("null propertyDef");
        }
        if (propertyExtractor == null) {
            throw new IllegalArgumentException("null propertyExtractor");
        }
        this.object = object;
        this.propertyDef = propertyDef;
        this.propertyExtractor = propertyExtractor;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    public Class<V> getType() {
        return this.propertyDef.getType();
    }

    public V getValue() {
        return this.propertyExtractor.getPropertyValue(this.object, this.propertyDef);
    }
}

