/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;
import org.dellroad.stuff.vaadin7.SelfKeyedContainer;
import org.dellroad.stuff.vaadin7.SpringVaadinServlet;
import org.dellroad.stuff.vaadin7.VaadinExternalListener;
import org.dellroad.stuff.vaadin7.VaadinSessionInfo;
import org.dellroad.stuff.vaadin7.VaadinUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VaadinSessionContainer<T extends VaadinSessionInfo>
extends SelfKeyedContainer<T> {
    protected final VaadinSession session;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SessionEventListener listener = new SessionEventListener();

    protected VaadinSessionContainer(Class<T> type) {
        super(type);
        this.session = VaadinUtil.getCurrentSession();
        SpringVaadinServlet.getServlet(this.session);
    }

    protected VaadinSessionContainer(PropertyExtractor<? super T> propertyExtractor, Collection<? extends PropertyDef<?>> propertyDefs) {
        super(propertyExtractor, propertyDefs);
        this.session = VaadinUtil.getCurrentSession();
        SpringVaadinServlet.getServlet(this.session);
    }

    @Override
    public void connect() {
        super.connect();
        this.listener.register();
        this.reload();
    }

    @Override
    public void disconnect() {
        this.listener.unregister();
        this.load(Collections.emptyList());
        super.disconnect();
    }

    public void reload() {
        new Thread("VaadinSessionContainer.reload()"){

            @Override
            public void run() {
                try {
                    VaadinSessionContainer.this.doReload();
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    VaadinSessionContainer.this.log.error("error reloading container " + this, t);
                }
            }
        }.start();
    }

    public void update() {
        new Thread("VaadinSessionContainer.update()"){

            @Override
            public void run() {
                try {
                    VaadinSessionContainer.this.doUpdate();
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    VaadinSessionContainer.this.log.error("error updating container " + this, t);
                }
            }
        }.start();
    }

    protected void doUpdate() {
        if (VaadinSession.getCurrent() != null && VaadinSession.getCurrent().hasLock()) {
            throw new IllegalStateException("inside locked VaadinSession");
        }
        final ArrayList sessionInfoList = new ArrayList();
        this.session.accessSynchronously(new Runnable(){

            @Override
            public void run() {
                sessionInfoList.addAll(VaadinSessionContainer.this.getItemIds());
            }
        });
        Iterator iterator = sessionInfoList.iterator();
        while (iterator.hasNext()) {
            VaadinSessionInfo sessionInfo;
            final VaadinSessionInfo sessionInfo2 = sessionInfo = (VaadinSessionInfo)iterator.next();
            sessionInfo.getVaadinSession().accessSynchronously(new Runnable(){

                @Override
                public void run() {
                    sessionInfo2.updateInformation();
                }
            });
        }
        this.session.accessSynchronously(new Runnable(){

            @Override
            public void run() {
                for (VaadinSessionInfo sessionInfo : sessionInfoList) {
                    sessionInfo.makeUpdatesVisible();
                }
            }
        });
    }

    protected void doReload() {
        if (VaadinSession.getCurrent() != null && VaadinSession.getCurrent().hasLock()) {
            throw new IllegalStateException("inside locked VaadinSession");
        }
        final ArrayList sessionInfoList = new ArrayList();
        for (VaadinSession otherSession : SpringVaadinServlet.getServlet(this.session).getSessions()) {
            otherSession.accessSynchronously(new Runnable(){

                @Override
                public void run() {
                    sessionInfoList.add(VaadinSessionContainer.this.createVaadinSessionInfo());
                }
            });
        }
        this.session.access(new Runnable(){

            @Override
            public void run() {
                VaadinSessionContainer.this.load(sessionInfoList);
            }
        });
        this.doUpdate();
    }

    protected abstract T createVaadinSessionInfo();

    private class SessionEventListener
    extends VaadinExternalListener<VaadinService>
    implements SessionInitListener,
    SessionDestroyListener {
        SessionEventListener() {
            super(VaadinUtil.getCurrentSession().getService());
        }

        public void sessionInit(SessionInitEvent event) {
            VaadinSessionContainer.this.reload();
        }

        public void sessionDestroy(SessionDestroyEvent event) {
            VaadinSessionContainer.this.reload();
        }

        @Override
        protected void register(VaadinService vaadinService) {
            vaadinService.addSessionInitListener((SessionInitListener)this);
            vaadinService.addSessionDestroyListener((SessionDestroyListener)this);
        }

        @Override
        protected void unregister(VaadinService vaadinService) {
            vaadinService.removeSessionInitListener((SessionInitListener)this);
            vaadinService.removeSessionDestroyListener((SessionDestroyListener)this);
        }
    }
}

