/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import java.util.Arrays;
import java.util.List;
import org.dellroad.stuff.vaadin7.InvalidQueryListException;
import org.dellroad.stuff.vaadin7.QueryList;

public class WindowQueryList<T>
implements QueryList<T> {
    private final List<? extends T> window;
    private final long offset;
    private final long totalSize;

    public WindowQueryList(List<? extends T> list, int offset, int count) {
        if (list == null) {
            throw new IllegalArgumentException("null list");
        }
        this.totalSize = list.size();
        if (offset < 0 || (long)offset > this.totalSize) {
            throw new IllegalArgumentException("bad offset");
        }
        this.offset = offset;
        if (count < 0 || (long)(offset + count) > this.totalSize) {
            throw new IllegalArgumentException("bad count");
        }
        this.window = Arrays.asList(list.subList(offset, offset + count).toArray());
    }

    public WindowQueryList(long offset, List<? extends T> window, long totalSize) {
        if (window == null) {
            throw new IllegalArgumentException("null window");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset < 0");
        }
        if (offset + (long)window.size() > totalSize) {
            throw new IllegalArgumentException("offset + window.size() > totalSize");
        }
        this.window = window;
        this.offset = offset;
        this.totalSize = totalSize;
    }

    @Override
    public long size() {
        return this.totalSize;
    }

    @Override
    public T get(long index) throws InvalidQueryListException {
        if (index < 0L || index >= this.totalSize) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        if (index < this.offset || index >= this.offset + (long)this.window.size()) {
            throw new InvalidQueryListException();
        }
        return this.window.get((int)(index - this.offset));
    }
}

