/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.hibernate.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractClasspathMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    protected abstract void addClasspathElements(Set<URL> var1) throws DependencyResolutionRequiredException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        try {
            this.addClasspathElements(urls);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("error adding classpath elements: " + e.getMessage(), (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)(((Object)((Object)this)).getClass().getSimpleName() + ": classpath for execution:"));
        urls.forEach(url -> this.getLog().debug((CharSequence)("  " + url)));
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader classpathLoader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), contextLoader);
        this.runWithLoader(classpathLoader, this::executeWithClasspath);
    }

    protected abstract void executeWithClasspath() throws MojoExecutionException, MojoFailureException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWithLoader(ClassLoader loader, MojoRunnable action) throws MojoExecutionException, MojoFailureException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            action.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    protected URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("unexpected error", e);
        }
    }

    @FunctionalInterface
    public static interface MojoRunnable {
        public void run() throws MojoExecutionException, MojoFailureException;
    }
}

