/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.hibernate.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.dellroad.hibernate.maven.AbstractClasspathMojo;
import org.dellroad.hibernate.maven.Fixup;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.internal.metadata.JpaMetadataDescriptor;

@Mojo(name="export-jpa-schema", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class ExportJpaMojo
extends AbstractClasspathMojo {
    private static final String GENERATED_JPA_UNIT_NAME = "generated";
    @Parameter(defaultValue="")
    private String jpaUnit;
    @Parameter(defaultValue="")
    private String dialect;
    @Parameter(defaultValue="${project.build.directory}/classes")
    private File classRoot;
    @Parameter(defaultValue="")
    private String removePersistenceXml;
    @Parameter(defaultValue="META-INF/hibernate-jpa-schemagen/persistence-template.xml")
    private String persistenceXmlTemplate;
    @Parameter
    private File propertyFile;
    @Parameter(defaultValue="${project.build.directory}/generated-resources/schema.ddl")
    private File outputFile;
    @Parameter(defaultValue="${project.basedir}/src/schema/schema.ddl")
    private String verifyFile;
    @Parameter(defaultValue="false")
    private boolean drop;
    @Parameter(defaultValue=";")
    private String delimiter;
    @Parameter(defaultValue="true")
    private boolean format;
    @Parameter
    private List<Fixup> fixups = new ArrayList<Fixup>();

    @Override
    protected void addClasspathElements(Set<URL> elements) throws DependencyResolutionRequiredException {
        elements.add(this.toURL(this.classRoot));
        Stream.of(this.project.getCompileClasspathElements(), this.project.getRuntimeClasspathElements()).flatMap(Collection::stream).map(File::new).map(this::toURL).forEach(elements::add);
    }

    @Override
    protected void executeWithClasspath() throws MojoExecutionException {
        boolean removePersistenceXmlBool;
        boolean hasDialect;
        boolean hasJpaUnit = !this.nullOrEmpty(this.jpaUnit);
        if (hasJpaUnit != !(hasDialect = !this.nullOrEmpty(this.dialect))) {
            throw new MojoExecutionException("Exactly one of <jpaUnit> or <dialect> must be configured");
        }
        File metaInf = new File(this.classRoot, "META-INF");
        File persistenceXml = new File(metaInf, "persistence.xml");
        if (hasDialect) {
            removePersistenceXmlBool = this.nullOrEmpty(this.removePersistenceXml) || Boolean.valueOf(this.removePersistenceXml) != false;
            this.jpaUnit = GENERATED_JPA_UNIT_NAME;
            this.generatePersistenceXml(persistenceXml);
        } else {
            boolean bl = removePersistenceXmlBool = !this.nullOrEmpty(this.removePersistenceXml) && Boolean.valueOf(this.removePersistenceXml) != false;
        }
        if (!persistenceXml.exists()) {
            throw new MojoExecutionException("No JPA persistence file found at location " + persistenceXml);
        }
        Properties properties = this.readProperties();
        this.getLog().info((CharSequence)"Gathering Hibernate meta-data");
        MetadataDescriptor metadataDescriptor = this.createMetadataDescriptor(properties);
        Exporter exporter = this.createExporter(properties);
        this.configureExporter(exporter, properties, metadataDescriptor);
        this.outputFile.delete();
        this.getLog().info((CharSequence)"Invoking Hibernate exporter");
        exporter.start();
        this.getLog().info((CharSequence)("Wrote generated schema to " + this.outputFile));
        if (removePersistenceXmlBool) {
            this.getLog().info((CharSequence)("Removing " + (hasDialect ? GENERATED_JPA_UNIT_NAME : "user-supplied") + " " + persistenceXml));
            persistenceXml.delete();
            metaInf.delete();
        }
        this.applyFixups(properties);
        this.verifyOutput();
    }

    protected boolean nullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    protected void generatePersistenceXml(File persistenceXml) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating " + persistenceXml));
        persistenceXml.getParentFile().mkdirs();
        try (InputStreamReader in = new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.persistenceXmlTemplate), StandardCharsets.UTF_8);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(persistenceXml), StandardCharsets.UTF_8);){
            int r;
            StringWriter buf = new StringWriter();
            char[] chunk = new char[256];
            while ((r = in.read(chunk)) != -1) {
                buf.write(chunk, 0, r);
            }
            out.write(buf.toString().replaceAll("@jpaName@", this.jpaUnit).replaceAll("@dialect@", this.dialect));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating " + persistenceXml + " from template " + this.persistenceXmlTemplate, (Exception)e);
        }
    }

    protected MetadataDescriptor createMetadataDescriptor(Properties properties) {
        return new JpaMetadataDescriptor(this.jpaUnit, properties);
    }

    protected Exporter createExporter(Properties properties) {
        Exporter exporter = ExporterFactory.createExporter((ExporterType)ExporterType.DDL);
        exporter.getProperties().putAll((Map<?, ?>)properties);
        return exporter;
    }

    protected void configureExporter(Exporter exporter, Properties properties, MetadataDescriptor metadataDescriptor) {
        exporter.getProperties().putAll((Map<?, ?>)properties);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", Optional.ofNullable(this.outputFile.getParentFile()).orElseGet(() -> new File(".")));
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", metadataDescriptor);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplatePath", new String[0]);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ExportToDatabase", (Object)false);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ExportToConsole", (Object)false);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.SchemaUpdate", (Object)false);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.Delimiter", this.delimiter);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DropDatabase", (Object)this.drop);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.CreateDatabase", (Object)true);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.Format", (Object)this.format);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.OutputFileName", this.outputFile.getName());
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.HaltOnError", (Object)true);
    }

    protected Properties readProperties() throws MojoExecutionException {
        Properties properties = new Properties();
        if (this.propertyFile != null) {
            this.getLog().debug((CharSequence)("Loading schema generation properties from " + this.propertyFile));
            try (FileInputStream input = new FileInputStream(this.propertyFile);){
                properties.load(input);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error loading " + this.propertyFile + ": " + e.getMessage(), (Exception)e);
            }
        }
        return properties;
    }

    protected void applyFixups(Properties properties) throws MojoExecutionException {
        if (this.fixups.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("Applying " + this.fixups.size() + " fixup(s) to " + this.outputFile));
        try {
            String charset = Optional.ofNullable(properties.getProperty("hibernate.hbm2ddl.charset_name")).orElse("utf-8");
            String ddl = new String(Files.readAllBytes(this.outputFile.toPath()), charset);
            int index = 1;
            for (Fixup fixup : this.fixups) {
                try {
                    this.getLog().debug((CharSequence)("Applying fixup #" + index + " to generated schema"));
                    ddl = fixup.applyTo(ddl);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException("Error applying schema fixup #" + index + ": " + e.getMessage(), (Exception)e);
                }
                ++index;
            }
            Files.write(this.outputFile.toPath(), ddl.getBytes(charset), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error applying schema fixups to " + this.outputFile + ": " + e.getMessage(), (Exception)e);
        }
    }

    protected void verifyOutput() throws MojoExecutionException {
        if (this.nullOrEmpty(this.verifyFile)) {
            this.getLog().info((CharSequence)"Not verifying generated schema (no verification file configured)");
            return;
        }
        File verifile = new File(this.verifyFile);
        if (!verifile.exists()) {
            throw new MojoExecutionException("Error verifying schema output: verification file " + verifile + " does not exist");
        }
        this.getLog().info((CharSequence)("Comparing generated schema to " + verifile));
        try {
            byte[] actual = Files.readAllBytes(this.outputFile.toPath());
            byte[] expected = Files.readAllBytes(verifile.toPath());
            if (!Arrays.equals(actual, expected)) {
                throw new MojoExecutionException("Generated schema differs from expected schema (schema migration may be needed)");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error verifying schema output against " + verifile + ": " + e.getMessage(), (Exception)e);
        }
        this.getLog().info((CharSequence)"Schema verification succeeded");
    }
}

