/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jct.jshell;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import jdk.jshell.tool.JavaShellToolBuilder;
import org.dellroad.jct.core.AbstractShellSession;
import org.dellroad.jct.core.Shell;
import org.dellroad.jct.core.ShellRequest;
import org.dellroad.jct.core.util.ConsoleUtil;
import org.dellroad.jct.jshell.JShellShell;
import org.dellroad.jct.jshell.LocalContextExecutionControlProvider;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;

public class JShellShellSession
extends AbstractShellSession {
    private static final InheritableThreadLocal<JShellShellSession> CURRENT_SESSION = new InheritableThreadLocal();
    protected ClassLoader localContextClassLoader;

    public JShellShellSession(JShellShell shell, ShellRequest request) {
        super((Shell)shell, request);
    }

    public static JShellShellSession getCurrent() {
        return (JShellShellSession)((Object)CURRENT_SESSION.get());
    }

    public void setLocalContextClassLoader(ClassLoader loader) {
        this.localContextClassLoader = loader;
    }

    public JShellShell getOwner() {
        return (JShellShell)super.getOwner();
    }

    protected PrintStream buildOutputStream(Terminal terminal) {
        return ConsoleUtil.unclosable((PrintStream)super.buildOutputStream(terminal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute() throws InterruptedException {
        JavaShellToolBuilder builder = this.createBuilder();
        Terminal terminal = ((ShellRequest)this.request).getTerminal();
        Attributes attr = terminal.enterRawMode();
        Thread currentThread = Thread.currentThread();
        ClassLoader previousLoader = currentThread.getContextClassLoader();
        JShellShellSession previousSession = (JShellShellSession)((Object)CURRENT_SESSION.get());
        List<String> jshellParams = this.modifyJShellParams(((ShellRequest)this.request).getShellArguments());
        if (jshellParams == null) {
            throw new IllegalArgumentException("null jshellParams");
        }
        CURRENT_SESSION.set(this);
        try {
            String[] params = jshellParams.toArray(new String[0]);
            if (ConsoleUtil.getJavaVersion() >= 11) {
                try {
                    int n = (Integer)JavaShellToolBuilder.class.getMethod("start", String[].class).invoke((Object)builder, new Object[]{params});
                    return n;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("unexpected error", e);
                }
            }
            builder.run(params);
            int n = 0;
            return n;
        }
        catch (Exception e) {
            this.out.println(String.format("Error: %s", e));
            int n = 1;
            return n;
        }
        finally {
            CURRENT_SESSION.set(previousSession);
            currentThread.setContextClassLoader(previousLoader);
            terminal.setAttributes(attr);
        }
    }

    protected JavaShellToolBuilder createBuilder() {
        JavaShellToolBuilder builder = JavaShellToolBuilder.builder();
        if (ConsoleUtil.getJavaVersion() >= 17) {
            try {
                JavaShellToolBuilder.class.getMethod("interactiveTerminal", Boolean.TYPE).invoke((Object)builder, true);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("unexpected error", e);
            }
        }
        builder.env(((ShellRequest)this.request).getEnvironment());
        builder.in(this.in, this.in);
        builder.out(this.out);
        return builder;
    }

    protected List<String> modifyJShellParams(List<String> params) {
        if (params == null) {
            throw new IllegalArgumentException("null params");
        }
        if (this.localContextClassLoader != null) {
            params = new ArrayList<String>(params);
            LocalContextExecutionControlProvider.modifyJShellFlags(this.localContextClassLoader, params);
        }
        return params;
    }
}

