/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jct.jshell;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import jdk.jshell.execution.LocalExecutionControl;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;
import org.dellroad.jct.jshell.MemoryLoaderDelegate;
import org.dellroad.stuff.java.MemoryClassLoader;

public class LocalContextExecutionControlProvider
implements ExecutionControlProvider {
    public static final String NAME = "localContext";

    public static void modifyJShellFlags(ClassLoader loader, List<String> flags) {
        if (flags == null) {
            throw new IllegalArgumentException("null flags");
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (LocalContextExecutionControlProvider.getExecutionFlag(flags) == null) {
            LocalContextExecutionControlProvider.setExecutionFlag(flags, NAME);
        }
        ArrayList<String> classpath = new ArrayList<String>();
        while (loader != null) {
            block13: {
                URL[] urls;
                if (loader instanceof URLClassLoader) {
                    urls = ((URLClassLoader)loader).getURLs();
                } else {
                    try {
                        Field field = loader.getClass().getDeclaredField("ucp");
                        field.setAccessible(true);
                        Object ucp = field.get(loader);
                        Method method = ucp.getClass().getMethod("getURLs", new Class[0]);
                        urls = (URL[])method.invoke(ucp, new Object[0]);
                    }
                    catch (ReflectiveOperationException | SecurityException | InaccessibleObjectException e) {
                        break block13;
                    }
                }
                for (URL url : urls) {
                    File file;
                    URI uri;
                    try {
                        uri = url.toURI();
                    }
                    catch (URISyntaxException e) {
                        continue;
                    }
                    try {
                        file = Paths.get(uri).toFile();
                    }
                    catch (IllegalArgumentException | FileSystemNotFoundException e) {
                        continue;
                    }
                    classpath.add(file.toString());
                }
            }
            loader = loader.getParent();
        }
        LocalContextExecutionControlProvider.addToClassPath(flags, classpath);
    }

    public static String getExecutionFlag(List<String> flags) {
        int index = flags.indexOf("--execution");
        return index >= 0 && index < flags.size() - 1 ? flags.get(index + 1) : null;
    }

    public static void setExecutionFlag(List<String> flags, String providerName) {
        if (flags == null) {
            throw new IllegalArgumentException("null flags");
        }
        if (providerName == null) {
            throw new IllegalArgumentException("null providerName");
        }
        int index = flags.indexOf("--execution");
        if (index >= 0) {
            if (index < flags.size() - 1) {
                flags.set(index + 1, providerName);
            } else {
                flags.add(providerName);
            }
        } else {
            flags.add("--execution");
            flags.add(providerName);
        }
    }

    public static void addToClassPath(List<String> commandLine, List<String> components) {
        if (commandLine == null) {
            throw new IllegalArgumentException("null commandLine");
        }
        if (components == null) {
            throw new IllegalArgumentException("null components");
        }
        StringBuilder classPath = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator", ":");
        Consumer<String> pathAdder = component -> {
            if (classPath.length() > 0) {
                classPath.append(pathSeparator);
            }
            classPath.append((String)component);
        };
        int i = 0;
        while (i < commandLine.size()) {
            String flag = commandLine.get(i);
            if (flag.startsWith("--class-path=")) {
                commandLine.remove(i);
                pathAdder.accept(flag.substring("--class-path=".length()));
                continue;
            }
            if (flag.equals("--class-path")) {
                commandLine.remove(i);
                if (i >= commandLine.size()) continue;
                pathAdder.accept(commandLine.remove(i));
                continue;
            }
            ++i;
        }
        components.forEach(pathAdder);
        if (classPath.length() > 0) {
            commandLine.add("--class-path");
            commandLine.add(classPath.toString());
        }
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Map<String, String> defaultParameters() {
        return ExecutionControlProvider.super.defaultParameters();
    }

    @Override
    public ExecutionControl generate(ExecutionEnv env, Map<String, String> params) {
        MemoryClassLoader memoryLoader = this.createMemoryClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)memoryLoader);
        MemoryLoaderDelegate delegate = this.createMemoryLoaderDelegate(memoryLoader);
        return this.createLocalExecutionControl(delegate);
    }

    protected MemoryLoaderDelegate createMemoryLoaderDelegate(MemoryClassLoader memoryLoader) {
        return new MemoryLoaderDelegate(memoryLoader);
    }

    protected MemoryClassLoader createMemoryClassLoader() {
        return new MemoryClassLoader();
    }

    protected LocalExecutionControl createLocalExecutionControl(MemoryLoaderDelegate delegate) {
        return new LocalExecutionControl(delegate);
    }
}

