/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.jct.jshell;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jdk.jshell.execution.LoaderDelegate;
import jdk.jshell.spi.ExecutionControl;
import org.dellroad.stuff.java.MemoryClassLoader;

public class MemoryLoaderDelegate
implements LoaderDelegate {
    private static final String JAR_FILE_PREFIX = "jar:file:";
    private final HashMap<String, Class<?>> classMap = new HashMap();
    private final MemoryClassLoader loader;

    public MemoryLoaderDelegate() {
        this(new MemoryClassLoader());
    }

    public MemoryLoaderDelegate(MemoryClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("null loader");
        }
        this.loader = loader;
    }

    public MemoryClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public void addToClasspath(String path) throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        try {
            for (String component : this.splitClassPath(path)) {
                this.loader.addURL(component.startsWith(JAR_FILE_PREFIX) ? new URL(component) : new File(component).toURI().toURL());
            }
        }
        catch (Exception e) {
            throw this.wrapCause(e, new ExecutionControl.InternalException(e.getMessage()));
        }
    }

    @Override
    public void classesRedefined(ExecutionControl.ClassBytecodes[] classes) {
        if (classes == null) {
            throw new IllegalArgumentException("null classes");
        }
        for (ExecutionControl.ClassBytecodes c : classes) {
            this.loader.putClass(c.name(), c.bytecodes());
        }
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("null className");
        }
        Class<?> cl = this.classMap.get(className);
        if (cl == null) {
            throw new ClassNotFoundException("class \"" + className + "\" not found");
        }
        return cl;
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] classes) throws ExecutionControl.ClassInstallException, ExecutionControl.EngineTerminationException {
        if (classes == null) {
            throw new IllegalArgumentException("null classes");
        }
        int numLoaded = 0;
        try {
            for (ExecutionControl.ClassBytecodes c : classes) {
                this.loader.putClass(c.name(), c.bytecodes());
            }
            for (ExecutionControl.ClassBytecodes c : classes) {
                Class cl = this.loader.loadClass(c.name());
                this.classMap.put(c.name(), cl);
                ++numLoaded;
                cl.getDeclaredMethods();
            }
        }
        catch (Throwable t) {
            boolean[] loaded = new boolean[classes.length];
            Arrays.fill(loaded, 0, numLoaded, true);
            throw this.wrapCause(t, new ExecutionControl.ClassInstallException(t.getMessage(), loaded));
        }
    }

    private <T extends Throwable, T2 extends Throwable> T2 wrapCause(T t, T2 t2) {
        t2.initCause(t);
        return t2;
    }

    private List<String> splitClassPath(String path) {
        ArrayList<String> components = new ArrayList<String>();
        int start = 0;
        while (start < path.length()) {
            int sep;
            int stop;
            String component;
            int look = start;
            if (path.substring(start).startsWith(JAR_FILE_PREFIX)) {
                look += JAR_FILE_PREFIX.length();
            }
            if (!(component = path.substring(start, stop = (sep = path.indexOf(File.pathSeparatorChar, look)) != -1 ? sep : path.length())).isEmpty()) {
                components.add(component);
            }
            start = Math.max(stop, sep + 1);
        }
        return components;
    }
}

