/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp;

import java.net.InetSocketAddress;

public class Endpoint {
    private final String host;
    private final int port;

    public Endpoint(String host, int port) {
        if (host == null) {
            throw new IllegalArgumentException("null host");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("invalid port " + port);
        }
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress toSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Endpoint that = (Endpoint)obj;
        return this.host.equals(that.host) && this.port == that.port;
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port;
    }
}

