/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dellroad.msrp.MsrpUri;
import org.dellroad.msrp.msg.ByteRange;
import org.dellroad.msrp.msg.FailureReport;
import org.dellroad.msrp.msg.Header;
import org.dellroad.msrp.msg.MsrpHeaders;
import org.dellroad.msrp.msg.MsrpRequest;
import org.dellroad.msrp.msg.ProtocolException;

public class InputChunks {
    private final String messageId;
    private final long maxContentLength;
    private final TreeSet<Header> headers = new TreeSet<Header>(Header.SORT_BY_NAME);
    private final ArrayList<long[]> holes = new ArrayList();
    private List<MsrpUri> fromPath;
    private boolean successReport;
    private FailureReport failureReport = FailureReport.YES;
    private String contentType;
    private boolean complete;
    private boolean aborted;
    private long contentLength = -1L;
    private long timestamp;
    private byte[] buf;

    public InputChunks(String messageId, long maxContentLength) {
        if (messageId == null) {
            throw new IllegalArgumentException("null messageId");
        }
        this.messageId = messageId;
        this.maxContentLength = maxContentLength;
        this.timestamp = System.nanoTime();
    }

    public synchronized boolean handleSend(MsrpRequest request) throws ProtocolException {
        if (request == null) {
            throw new IllegalArgumentException("null request");
        }
        if (!"SEND".equals(request.getMethod())) {
            throw new IllegalArgumentException("request method " + request.getMethod() + " != " + "SEND");
        }
        MsrpHeaders requestHeaders = request.getHeaders();
        if (!this.messageId.equals(requestHeaders.getMessageId())) {
            throw new IllegalArgumentException("request message ID " + requestHeaders.getMessageId() + " != " + this.messageId);
        }
        request.validate();
        this.timestamp = System.nanoTime();
        this.fromPath = requestHeaders.getFromPath();
        this.successReport |= requestHeaders.isSuccessReport();
        if (requestHeaders.getFailureReport() != null) {
            this.failureReport = requestHeaders.getFailureReport();
        }
        this.headers.addAll(requestHeaders.getExtensionHeaders());
        if (request.isAborted()) {
            this.aborted = true;
            return true;
        }
        byte[] body = request.getBody();
        if (body == null) {
            if (this.buf != null) {
                throw new ProtocolException("continuation request must have a body");
            }
            ByteRange byteRange = requestHeaders.getByteRange();
            if (byteRange != null && !byteRange.equals(ByteRange.EMPTY)) {
                throw new ProtocolException("invalid ByteRange " + byteRange + " for message having no body");
            }
            this.complete = true;
            return true;
        }
        this.contentType = requestHeaders.getContentType();
        this.headers.addAll(requestHeaders.getMimeHeaders());
        ByteRange byteRange = requestHeaders.getByteRange();
        if (byteRange == null) {
            byteRange = new ByteRange(body.length);
        }
        long expectedEnd = byteRange.getStart() + (long)body.length - 1L;
        if (byteRange.getEnd() == -1L) {
            byteRange = new ByteRange(byteRange.getStart(), expectedEnd, byteRange.getTotal());
        } else if (byteRange.getEnd() != expectedEnd) {
            throw new ProtocolException("rec'd inconsistent ByteRange " + byteRange + " with end byte " + byteRange.getEnd() + " != " + expectedEnd + " expected based on body size");
        }
        long offset = byteRange.getStart() - 1L;
        long limit = offset + (long)body.length;
        if (this.contentLength == -1L) {
            if (byteRange.getTotal() != -1L) {
                this.contentLength = byteRange.getTotal();
            }
        } else if (byteRange.getTotal() != -1L && byteRange.getTotal() != this.contentLength) {
            throw new ProtocolException("rec'd inconsistent ByteRange " + byteRange + " with total " + byteRange.getTotal() + " != previously rec'd total " + this.contentLength);
        }
        if (this.contentLength != -1L && byteRange.getEnd() == this.contentLength && !request.isComplete()) {
            throw new ProtocolException("last chunk in " + byteRange + " message has unexpected incomplete flag");
        }
        long minimumLength = Math.max(limit, this.contentLength);
        if (minimumLength > this.maxContentLength || minimumLength > Integer.MAX_VALUE) {
            throw new ProtocolException("content is too large (" + minimumLength + " > " + this.maxContentLength + " bytes)");
        }
        if (this.buf == null) {
            this.buf = new byte[0];
        }
        if ((long)this.buf.length < minimumLength) {
            this.holes.add(new long[]{this.buf.length, minimumLength});
            byte[] newBuf = new byte[(int)minimumLength];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
        System.arraycopy(body, 0, this.buf, (int)offset, body.length);
        for (int i = 0; i < this.holes.size(); ++i) {
            long[] hole = this.holes.get(i);
            assert (hole[0] < hole[1]);
            if (hole[1] <= offset || hole[0] >= limit) continue;
            if (hole[0] >= offset && hole[1] <= limit) {
                this.holes.remove(i--);
                continue;
            }
            if (hole[1] <= limit) {
                hole[1] = offset;
                continue;
            }
            if (hole[0] >= offset) {
                hole[0] = limit;
                continue;
            }
            this.holes.set(i, new long[]{hole[0], offset});
            this.holes.add(++i, new long[]{limit, hole[1]});
        }
        this.complete |= request.isComplete() && this.holes.isEmpty();
        return this.complete;
    }

    public synchronized long getIdleTime() {
        return (System.nanoTime() - this.timestamp) / 1000000L;
    }

    public synchronized String getMessageId() {
        return this.messageId;
    }

    public synchronized List<MsrpUri> getFromPath() {
        return this.fromPath;
    }

    public synchronized byte[] getContent() {
        return this.buf;
    }

    public synchronized String getContentType() {
        return this.contentType;
    }

    public synchronized SortedSet<Header> getHeaders() {
        return Collections.unmodifiableSortedSet(this.headers);
    }

    public synchronized boolean isComplete() {
        return this.complete;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    public synchronized boolean isSuccessReport() {
        return this.successReport;
    }

    public synchronized FailureReport getFailureReport() {
        return this.failureReport;
    }
}

