/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.UserInterruptException;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.dellroad.msrp.FailureListener;
import org.dellroad.msrp.Msrp;
import org.dellroad.msrp.MsrpUri;
import org.dellroad.msrp.Session;
import org.dellroad.msrp.SessionListener;
import org.dellroad.msrp.SuccessListener;
import org.dellroad.msrp.msg.ByteRange;
import org.dellroad.msrp.msg.Header;
import org.dellroad.msrp.msg.Status;
import org.dellroad.stuff.main.MainClass;
import org.dellroad.stuff.string.ByteArrayEncoder;
import org.dellroad.stuff.string.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
extends MainClass {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SessionListener sessionListener = new MainSessionListener();
    private final MainReportListener reportListener = new MainReportListener();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Msrp msrp = new Msrp();
    private int port = 2855;
    private ConsoleReader console;
    private PrintWriter writer;
    private FileHistory history;
    private CursorBuffer cursorBuffer;
    private boolean verbose;
    private volatile MsrpUri currentSession;
    private volatile String lastReceivedMessageId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        ArrayDeque<String> params = new ArrayDeque<String>(Arrays.asList(args));
        while (!params.isEmpty() && params.peekFirst().startsWith("-")) {
            String option = params.removeFirst();
            if (option.equals("-h") || option.equals("--help")) {
                this.usageMessage();
                return 0;
            }
            if (option.equals("-v") || option.equals("--verbose")) {
                this.verbose = true;
                continue;
            }
            if (option.equals("--port")) {
                this.port = this.parseIntParam(params, "port");
                continue;
            }
            if (option.equals("--max-sessions")) {
                this.msrp.setMaxSessions(this.parseIntParam(params, "max-sessions"));
                continue;
            }
            if (option.equals("--max-content-length")) {
                this.msrp.setMaxContentLength(this.parseIntParam(params, "max-content-length"));
                continue;
            }
            if (option.equals("--idle-timeout")) {
                this.msrp.setMaxIdleTime((long)this.parseIntParam(params, "idle-timeout") * 1000L);
                continue;
            }
            if (option.equals("--connect-timeout")) {
                this.msrp.setConnectTimeout((long)this.parseIntParam(params, "connect-timeout") * 1000L);
                continue;
            }
            if (option.equals("--")) break;
            System.err.println(this.getName() + ": unknown option `" + option + "'");
            this.usageError();
        }
        switch (params.size()) {
            case 0: {
                break;
            }
            default: {
                this.usageError();
                return 1;
            }
        }
        this.console = new ConsoleReader((InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)System.out);
        this.console.setBellEnabled(true);
        this.console.setHistoryEnabled(true);
        this.console.setHandleUserInterrupt(true);
        this.writer = new PrintWriter(this.console.getOutput(), true);
        try {
            this.history = new FileHistory(new File(new File(System.getProperty("user.home")), ".msrp_history"));
        }
        catch (IOException option) {
            // empty catch block
        }
        this.console.setHistory((History)this.history);
        this.msrp.setListenAddress(new InetSocketAddress(this.port));
        this.msrp.start();
        this.writer.println("Welcome to msrp4j. Type `help' for help.");
        this.writer.println("Listening on address " + this.msrp.getListenAddress());
        StringBuilder lineBuffer = new StringBuilder();
        try {
            boolean done = false;
            while (!done) {
                block58: {
                    String line;
                    try {
                        line = this.console.readLine(lineBuffer.length() == 0 ? "msrp4j> " : "     -> ");
                    }
                    catch (UserInterruptException e) {
                        this.writer.print("^C");
                        line = null;
                    }
                    if (line == null) {
                        this.writer.println();
                        break;
                    }
                    boolean continuation = false;
                    if (line.length() > 0 && line.charAt(line.length() - 1) == '\\') {
                        line = line.substring(0, line.length() - 1) + "\n";
                        continuation = true;
                    }
                    lineBuffer.append(line);
                    if (continuation) continue;
                    ParseContext ctx = new ParseContext(lineBuffer.toString());
                    lineBuffer.setLength(0);
                    ctx.skipWhitespace();
                    if (ctx.getInput().length() == 0) continue;
                    String command = ctx.matchPrefix("([^\\s]+)\\s*").group(1);
                    try {
                        switch (command) {
                            case "connect": 
                            case "accept": {
                                MsrpUri localURI = new MsrpUri(ctx.matchPrefix("([^\\s]+)\\s*").group(1));
                                MsrpUri remoteURI = new MsrpUri(ctx.matchPrefix("([^\\s]+)\\s*").group(1));
                                this.open(localURI, remoteURI, command.equals("connect"));
                                break;
                            }
                            case "close": {
                                this.close();
                                break;
                            }
                            case "list": {
                                this.list();
                                break;
                            }
                            case "select": {
                                this.currentSession = new MsrpUri(ctx.matchPrefix("([^\\s]+)\\s*").group(1));
                                this.writer.println("* New current session is " + this.currentSession);
                                break;
                            }
                            case "text": {
                                this.send(new ByteArrayInputStream(ctx.getInput().getBytes(UTF8)), "text/plain; charset=utf-8");
                                break;
                            }
                            case "send": {
                                if (ctx.getInput().length() == 0) {
                                    this.send(null, null);
                                    break;
                                }
                                File file = new File(ctx.matchPrefix("([^\\s]+)\\s*").group(1));
                                String contentType = ctx.matchPrefix("[^\\s]+").group();
                                this.send(new FileInputStream(file), contentType);
                                break;
                            }
                            case "success": {
                                String messageId = this.lastReceivedMessageId;
                                if (ctx.getInput().length() > 0) {
                                    messageId = ctx.matchPrefix("([^\\s]+)\\s*").group(1);
                                }
                                if (messageId == null) {
                                    throw new Exception("no message rec'd yet");
                                }
                                ByteRange byteRange = ByteRange.ALL;
                                if (ctx.getInput().length() > 0) {
                                    byteRange = ByteRange.fromString(ctx.getInput());
                                }
                                this.success(messageId, byteRange);
                                break;
                            }
                            case "failure": {
                                String messageId = this.lastReceivedMessageId;
                                if (ctx.getInput().length() > 0) {
                                    messageId = ctx.matchPrefix("([^\\s]+)\\s*").group(1);
                                }
                                if (messageId == null) {
                                    throw new Exception("no message rec'd yet");
                                }
                                int code = 400;
                                if (ctx.getInput().length() > 0) {
                                    code = Integer.parseInt(ctx.matchPrefix("([^\\s]+)\\s*").group(1));
                                }
                                String comment = "Unspecified error";
                                if (ctx.getInput().length() > 0) {
                                    comment = ctx.matchPrefix("([^\\s]+)\\s*").group(1);
                                }
                                this.failure(messageId, new Status(code, comment));
                                break;
                            }
                            case "quit": {
                                this.writer.println("* Bye");
                                done = true;
                                break;
                            }
                            case "help": {
                                this.writer.println("Available commands:");
                                this.writer.println("  connect localURI remoteURI");
                                this.writer.println("      Create an active session using the given URIs");
                                this.writer.println("  accept localURI remoteURI");
                                this.writer.println("      Create a passive session using the given URIs");
                                this.writer.println("  close");
                                this.writer.println("      Shutdown selected session");
                                this.writer.println("  list");
                                this.writer.println("      List all known sessions");
                                this.writer.println("  select localURI");
                                this.writer.println("      Select current session");
                                this.writer.println("  text ...");
                                this.writer.println("      Send a text message");
                                this.writer.println("  send");
                                this.writer.println("      Send a message with no content");
                                this.writer.println("  send name content-type");
                                this.writer.println("      Send arbitrary file");
                                this.writer.println("  success [ messageId [ byte-range ] ]");
                                this.writer.println("      Send success report");
                                this.writer.println("  failure [ messageId [ code [ comment ... ] ] ]");
                                this.writer.println("      Send failure report");
                                this.writer.println("  quit");
                                this.writer.println("      Close all sessions and quit");
                                this.writer.println("  help");
                                this.writer.println("      Show commands");
                                break;
                            }
                            default: {
                                throw new Exception("unknown command `" + command + "'; type `help' for help.");
                            }
                        }
                    }
                    catch (Exception e) {
                        String msg = e.getMessage() != null ? e.getMessage() : "" + e;
                        this.writer.println("Error: " + msg);
                        if (!this.verbose) break block58;
                        e.printStackTrace(this.writer);
                    }
                }
                this.writer.flush();
            }
        }
        finally {
            if (this.history != null) {
                this.history.flush();
            }
            this.writer.flush();
            this.console.flush();
            this.console.shutdown();
        }
        this.msrp.stop();
        return 0;
    }

    private void stashLine() {
        this.cursorBuffer = this.console.getCursorBuffer().copy();
        try {
            this.console.getOutput().write("\u001b[1G\u001b[K");
            this.console.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void unstashLine() {
        try {
            this.console.resetPromptLine(this.console.getPrompt(), this.cursorBuffer.toString(), this.cursorBuffer.cursor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getName() {
        return "msrp";
    }

    protected void usageMessage() {
        System.err.println("Usage:");
        System.err.println("  " + this.getName() + " [options]");
        System.err.println("Options:");
        System.err.println("  --port port           Port for incoming connections (default 2855)");
        System.err.println("  --verbose             Include exception traces when reporting errors");
        System.err.println("  --max-sessions        Set maximum allowed number of sessions");
        System.err.println("  --max-content-length  Set maximum allowed message content length");
        System.err.println("  --idle-timeout        Set maximum allowed time for idle connections (in seconds)");
        System.err.println("  --connect-timeout     Set connection timeout for outbound connections (in seconds)");
    }

    public static void main(String[] args) throws Exception {
        new Main().doMain(args);
    }

    private int parseIntParam(ArrayDeque<String> params, String name) {
        if (params.isEmpty()) {
            this.usageError();
            return 0;
        }
        String string = params.removeFirst();
        try {
            return Integer.parseInt(string, 10);
        }
        catch (Exception e) {
            System.err.println(this.getName() + ": invalid " + name + " `" + string + "'");
            this.usageError();
            return 0;
        }
    }

    private void open(MsrpUri localURI, MsrpUri remoteURI, boolean active) throws Exception {
        Session session = this.msrp.createSession(localURI, remoteURI, null, this.sessionListener, this.executor, active);
        this.writer.println("* Created session: local=" + session.getLocalUri() + " remote=" + session.getRemoteUri());
        this.writer.println("* New current session is " + session.getLocalUri());
        this.currentSession = localURI;
    }

    private void send(InputStream input, String contentType) throws Exception {
        Session session = this.findCurrentSession();
        if (input == null) {
            session.send(null, this.reportListener);
            return;
        }
        String messageId = session.send(input, -1, contentType, null, this.reportListener);
        this.writer.println("* Sent message with message ID " + messageId);
    }

    private Session findCurrentSession() {
        if (this.currentSession == null) {
            throw new RuntimeException("no current session; use `select' command to select one");
        }
        Session session = (Session)this.msrp.getSessions().get(this.currentSession);
        if (session == null) {
            throw new RuntimeException("no session found corresponding to local URI " + this.currentSession);
        }
        return session;
    }

    private void close() {
        Session session = this.findCurrentSession();
        this.writer.println("* Closing session " + session.getLocalUri());
        session.close(null);
    }

    private void list() {
        SortedMap<MsrpUri, Session> sessionMap = this.msrp.getSessions();
        this.writer.println("* " + sessionMap.size() + " active sessions:");
        for (Session session : sessionMap.values()) {
            MsrpUri localURI = session.getLocalUri();
            this.writer.println((localURI.equals(this.currentSession) ? "* " : "  ") + localURI + " -> " + session.getRemoteUri());
        }
    }

    private void success(String messageId, ByteRange byteRange) {
        Session session = this.findCurrentSession();
        this.writer.println("* Sending success report to " + session.getRemoteUri());
        session.sendSuccessReport(Collections.singletonList(session.getRemoteUri()), messageId, byteRange, null);
    }

    private void failure(String messageId, Status status) {
        Session session = this.findCurrentSession();
        this.writer.println("* Sending failure report to " + session.getRemoteUri());
        session.sendFailureReport(Collections.singletonList(session.getRemoteUri()), messageId, status);
    }

    private class MainReportListener
    implements SuccessListener,
    FailureListener {
        private MainReportListener() {
        }

        @Override
        public void reportFailure(Session session, String messageId, Status status) {
            Main.this.stashLine();
            Main.this.writer.println("* Rec'd failure from " + session.getRemoteUri() + ":");
            Main.this.writer.println("  Message-ID: " + messageId);
            Main.this.writer.println("  Status: " + status);
            Main.this.unstashLine();
        }

        @Override
        public void reportSuccess(Session session, String messageId, ByteRange byteRange) {
            Main.this.stashLine();
            Main.this.writer.println("* Rec'd success from " + session.getRemoteUri() + ":");
            Main.this.writer.println("  Message-ID: " + messageId);
            Main.this.writer.println("  ByteRange: " + byteRange);
            Main.this.unstashLine();
        }
    }

    private class MainSessionListener
    implements SessionListener {
        private MainSessionListener() {
        }

        @Override
        public void sessionClosed(Session session, Exception cause) {
            Main.this.stashLine();
            Main.this.writer.println("* Session " + session.getLocalUri() + " closed: " + cause);
            if (session.getLocalUri().equals(Main.this.currentSession)) {
                try {
                    Main.this.currentSession = Main.this.msrp.getSessions().values().iterator().next().getLocalUri();
                }
                catch (NoSuchElementException e) {
                    Main.this.currentSession = null;
                }
            }
            Main.this.unstashLine();
        }

        @Override
        public void sessionReceivedMessage(Session session, List<MsrpUri> fromPath, String messageId, byte[] content, String contentType, SortedSet<Header> headers, boolean successReport, boolean failureReport) {
            Main.this.stashLine();
            Main.this.writer.println("* Rec'd message from " + session.getRemoteUri() + ":");
            Main.this.writer.println("  Message-ID: " + messageId);
            Main.this.writer.println("  Success-Report: " + (successReport ? "yes" : "no"));
            Main.this.writer.println("  Failure-Report: " + (failureReport ? "yes" : "no"));
            for (Header header : headers) {
                Main.this.writer.println("  " + header);
            }
            if (content == null) {
                Main.this.writer.println("  [ Message contains no content ]");
            } else {
                MessageDigest sha1;
                Main.this.writer.println("  Content-Type: " + contentType);
                try {
                    sha1 = MessageDigest.getInstance("SHA");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                Main.this.writer.println("  Actual Length: " + content.length + " bytes");
                Main.this.writer.println("  Content SHA1: " + ByteArrayEncoder.encode((byte[])sha1.digest(content)));
                if (contentType.startsWith("text/plain")) {
                    String name = "utf-8";
                    Matcher matcher = Pattern.compile(".*charset=([^; ]+).*").matcher(contentType);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                    }
                    Charset charset = null;
                    try {
                        charset = Charset.forName(name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (charset != null) {
                        Main.this.writer.println();
                        Main.this.writer.println(new String(content, charset));
                        Main.this.writer.println();
                    }
                }
            }
            Main.this.unstashLine();
            Main.this.lastReceivedMessageId = messageId;
        }
    }
}

