/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.dellroad.msrp.Connection;
import org.dellroad.msrp.Endpoint;
import org.dellroad.msrp.MsrpUri;
import org.dellroad.msrp.MsrpUriComparator;
import org.dellroad.msrp.SelectorService;
import org.dellroad.msrp.Session;
import org.dellroad.msrp.SessionListener;
import org.dellroad.msrp.msg.MsrpMessage;
import org.dellroad.msrp.msg.MsrpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Msrp {
    public static final int DEFAULT_MAX_SESSIONS = 1000;
    public static final long DEFAULT_MAX_IDLE_TIME = 30000L;
    public static final long DEFAULT_CONNECT_TIMEOUT = 20000L;
    private static final int MAX_ORPHANS = 100;
    private static final int MAX_ORPHAN_HOLD_TIME = 500;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TreeMap<MsrpUri, Session> sessionMap = new TreeMap(MsrpUriComparator.INSTANCE);
    private final HashSet<Connection> connections = new HashSet();
    private final HashSet<Orphan> orphans = new HashSet(100);
    private InetSocketAddress listenAddress;
    private int maxSessions = 1000;
    private long maxContentLength = 0x1000000L;
    private long maxIdleTime = 30000L;
    private long connectTimeout = 20000L;
    private boolean matchSessionId = true;
    private ServerSocketChannel serverSocketChannel;
    private SelectionKey selectionKey;
    private Selector selector;
    private ServiceThread serviceThread;

    public synchronized InetSocketAddress getListenAddress() {
        return this.listenAddress;
    }

    public synchronized void setListenAddress(InetSocketAddress listenAddress) {
        this.listenAddress = listenAddress;
    }

    public synchronized int getMaxSessions() {
        return this.maxSessions;
    }

    public synchronized void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public synchronized long getMaxContentLength() {
        return this.maxContentLength;
    }

    public synchronized void setMaxContentLength(long maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public synchronized long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public synchronized long getConnectTimeout() {
        return this.connectTimeout;
    }

    public synchronized void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public synchronized boolean isMatchSessionId() {
        return this.matchSessionId;
    }

    public synchronized void setMatchSessionId(boolean matchSessionId) {
        this.matchSessionId = matchSessionId;
    }

    public synchronized void start() throws IOException {
        if (this.serviceThread != null) {
            return;
        }
        if (this.listenAddress == null) {
            this.listenAddress = new InetSocketAddress(2855);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("starting " + this + " listening on " + this.listenAddress);
        }
        boolean successful = false;
        try {
            this.selector = Selector.open();
            this.serverSocketChannel = ServerSocketChannel.open();
            this.configureServerSocketChannel(this.serverSocketChannel);
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.bind(this.listenAddress);
            this.selectionKey = this.createSelectionKey(this.serverSocketChannel, new SelectorService(){

                @Override
                public void serviceIO(SelectionKey key) throws IOException {
                    if (key.isAcceptable()) {
                        Msrp.this.handleAccept();
                    }
                }

                @Override
                public void close(Exception cause) {
                    Msrp.this.log.error("stopping " + this + " due to exception", (Throwable)cause);
                    Msrp.this.stop();
                }
            });
            this.selectForAccept(true);
            this.serviceThread = new ServiceThread();
            this.serviceThread.start();
            successful = true;
        }
        finally {
            if (!successful) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ServiceThread waitForThread = null;
        Msrp msrp = this;
        synchronized (msrp) {
            if (this.serviceThread != null && this.log.isDebugEnabled()) {
                this.log.debug("stopping " + this);
            }
            if (this.serverSocketChannel != null) {
                try {
                    this.serverSocketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.serverSocketChannel = null;
            }
            if (this.selector != null) {
                try {
                    this.selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.selector = null;
            }
            if (this.serviceThread != null) {
                this.serviceThread.interrupt();
                if (!this.serviceThread.equals(Thread.currentThread())) {
                    waitForThread = this.serviceThread;
                }
                this.serviceThread = null;
            }
            this.selectionKey = null;
        }
        if (waitForThread != null) {
            try {
                waitForThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized Session createSession(MsrpUri localURI, MsrpUri remoteURI, Endpoint endpoint, SessionListener listener, Executor callbackExecutor, boolean active) {
        if (localURI == null) {
            throw new IllegalArgumentException("null localURI");
        }
        if (remoteURI == null) {
            throw new IllegalArgumentException("null remoteURI");
        }
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        if (callbackExecutor == null) {
            throw new IllegalArgumentException("null callbackExecutor");
        }
        if (this.serviceThread == null) {
            throw new IllegalStateException("not started");
        }
        if (endpoint == null) {
            endpoint = remoteURI.toEndpoint();
        }
        if (this.sessionMap.containsKey(localURI)) {
            throw new IllegalArgumentException("duplicate session local URI `" + localURI + "'");
        }
        if (this.sessionMap.size() >= this.maxSessions) {
            this.log.warn("too many MSRP connections (" + this.sessionMap.size() + " >= " + this.maxSessions + "), not creating any more");
            return null;
        }
        Session session = new Session(this, localURI, remoteURI, active ? endpoint : null, listener, callbackExecutor);
        this.sessionMap.put(localURI, session);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + " created new session " + session);
        }
        if (!active) {
            if (!this.orphans.isEmpty()) {
                this.wakeup();
            }
            return session;
        }
        for (Connection connection : this.connections) {
            if (!connection.getEndpoint().equals(endpoint)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug(this + " binding " + session + " to existing " + connection);
            }
            session.setConnection(connection);
            break;
        }
        session.send(null, null);
        this.wakeup();
        return session;
    }

    public synchronized SortedMap<MsrpUri, Session> getSessions() {
        return new TreeMap<MsrpUri, Session>((SortedMap<MsrpUri, Session>)this.sessionMap);
    }

    protected void configureServerSocketChannel(ServerSocketChannel serverSocketChannel) {
    }

    protected void configureSocketChannel(SocketChannel socketChannel, Endpoint endpoint) {
    }

    public String toString() {
        return "Msrp[port=" + this.listenAddress.getPort() + "]";
    }

    Connection createConnection(Endpoint endpoint) throws IOException {
        InetSocketAddress socketAddress;
        SocketChannel socketChannel = SocketChannel.open();
        this.configureSocketChannel(socketChannel, endpoint);
        socketChannel.configureBlocking(false);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + " looking up DNS name `" + endpoint.getHost() + "'");
        }
        if ((socketAddress = endpoint.toSocketAddress()).isUnresolved()) {
            throw new IOException("DNS lookup failure for `" + socketAddress.getHostString() + "'");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ": `" + endpoint.getHost() + "' resolves to " + socketAddress.getAddress() + "; initiating connection");
        }
        socketChannel.connect(socketAddress);
        Connection connection = new Connection(this, endpoint, socketChannel);
        this.connections.add(connection);
        return connection;
    }

    void handleMessage(Connection connection, MsrpMessage message) throws IOException {
        MsrpUri localURI = message.getHeaders().getToPath().get(0);
        Session session = this.findSession(localURI);
        if (session == null) {
            if (!(message instanceof MsrpRequest)) {
                return;
            }
            MsrpRequest request = (MsrpRequest)message;
            if (this.orphans.size() >= 100) {
                connection.write(Session.createMsrpResponse(request, 481, "Session does not exist"));
                return;
            }
            this.orphans.add(new Orphan(connection, request));
            return;
        }
        if (session.getConnection() == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this + " binding " + session + " to " + connection);
            }
            session.setConnection(connection);
            this.wakeup();
        } else if (!session.getConnection().equals(connection)) {
            if (message instanceof MsrpRequest) {
                connection.write(Session.createMsrpResponse((MsrpRequest)message, 506, "Session already bound to a different connection"));
            }
            return;
        }
        session.handleMessage(message);
    }

    void handleConnectionClosed(Connection connection, Exception cause) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + " handling closed connection " + connection);
        }
        Iterator<Object> i = this.sessionMap.values().iterator();
        while (i.hasNext()) {
            Session session = i.next();
            if (!connection.equals(session.getConnection())) continue;
            i.remove();
            session.close(cause);
        }
        i = this.orphans.iterator();
        while (i.hasNext()) {
            if (!((Orphan)i.next()).getConnection().equals(connection)) continue;
            i.remove();
        }
        this.connections.remove(connection);
        this.wakeup();
    }

    void handleSessionClosed(Session session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + " handling closed session " + session);
        }
        this.sessionMap.remove(session.getLocalUri());
        this.wakeup();
    }

    SelectionKey createSelectionKey(SelectableChannel channel, SelectorService service) throws ClosedChannelException {
        if (channel == null) {
            throw new IllegalArgumentException("null channel");
        }
        if (service == null) {
            throw new IllegalArgumentException("null service");
        }
        if (this.selector == null) {
            return null;
        }
        this.wakeup();
        return channel.register(this.selector, 0, service);
    }

    private synchronized void handleAccept() throws IOException {
        if (this.connections.size() >= this.maxSessions) {
            this.log.warn("too many MSRP connections (" + this.connections.size() + " >= " + this.maxSessions + "), not accepting any more (for now)");
            this.selectForAccept(false);
            return;
        }
        SocketChannel socketChannel = this.serverSocketChannel.accept();
        if (socketChannel == null) {
            return;
        }
        socketChannel.configureBlocking(false);
        InetSocketAddress remote = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        Endpoint endpoint = new Endpoint(remote.getHostString(), remote.getPort());
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + " accepted incoming connection from " + endpoint);
        }
        this.connections.add(new Connection(this, endpoint, socketChannel));
    }

    private void selectForAccept(boolean enabled) throws IOException {
        if (this.selectionKey == null) {
            return;
        }
        try {
            if (enabled && (this.selectionKey.interestOps() & 0x10) == 0) {
                this.selectionKey.interestOps(this.selectionKey.interestOps() | 0x10);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this + " started listening for incoming connections");
                }
            } else if (!enabled && (this.selectionKey.interestOps() & 0x10) != 0) {
                this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFEF);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(this + " stopped listening for incoming connections");
                }
            }
        }
        catch (CancelledKeyException e) {
            throw new IOException("selection key has been canceled", e);
        }
    }

    void wakeup() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("wakeup service thread");
        }
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void service() throws IOException {
        while (true) {
            Selector currentSelector;
            Msrp msrp = this;
            synchronized (msrp) {
                currentSelector = this.selector;
            }
            if (currentSelector == null) break;
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[SVC THREAD]: sleeping: keys=" + Msrp.dbg(currentSelector.keys()));
                }
                currentSelector.select(1000L);
            }
            catch (ClosedSelectorException e) {
                break;
            }
            if (Thread.interrupted()) break;
            msrp = this;
            synchronized (msrp) {
                if (this.selector == null) {
                    for (Connection connection : new ArrayList<Connection>(this.connections)) {
                        connection.close(null);
                    }
                    break;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[SVC THREAD]: awake: selectedKeys=" + Msrp.dbg(currentSelector.selectedKeys()));
                }
                Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                while (i.hasNext()) {
                    SelectionKey key = i.next();
                    i.remove();
                    SelectorService service = (SelectorService)key.attachment();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("[SVC THREAD]: I/O ready: key=" + Msrp.dbg(key) + " service=" + service);
                    }
                    try {
                        service.serviceIO(key);
                    }
                    catch (IOException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("MSRP I/O error from " + service, (Throwable)e);
                        }
                        service.close(e);
                    }
                    catch (Exception e) {
                        this.log.error("MSRP service error from " + service, (Throwable)e);
                        service.close(e);
                    }
                }
                HashSet<Connection> activeConnections = new HashSet<Connection>();
                for (Session session : new ArrayList<Session>(this.sessionMap.values())) {
                    if (session.getConnection() != null) {
                        activeConnections.add(session.getConnection());
                    }
                    try {
                        session.performHousekeeping();
                    }
                    catch (IOException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("MSRP I/O error from " + session, (Throwable)e);
                        }
                        session.close(e);
                    }
                    catch (Exception e) {
                        this.log.error("error performing housekeeping for " + session, (Throwable)e);
                        session.close(e);
                    }
                }
                for (Connection connection : new ArrayList<Connection>(this.connections)) {
                    try {
                        connection.performHousekeeping(activeConnections.contains(connection));
                    }
                    catch (IOException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("MSRP I/O error from " + connection, (Throwable)e);
                        }
                        connection.close(e);
                    }
                    catch (Exception e) {
                        this.log.error("error performing housekeeping for " + connection, (Throwable)e);
                        connection.close(e);
                    }
                }
                this.selectForAccept(this.connections.size() < this.maxSessions);
                for (Orphan orphan : new ArrayList<Orphan>(this.orphans)) {
                    MsrpRequest request = orphan.getRequest();
                    Connection connection = orphan.getConnection();
                    if (orphan.getAge() >= 500L) {
                        this.orphans.remove(orphan);
                        try {
                            connection.write(Session.createMsrpResponse(request, 481, "Session does not exist"));
                        }
                        catch (IOException e) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("MSRP I/O error from " + connection, (Throwable)e);
                            }
                            connection.close(e);
                        }
                        catch (Exception e) {
                            this.log.error("MSRP error from " + connection, (Throwable)e);
                            connection.close(e);
                        }
                        continue;
                    }
                    MsrpUri localURI = request.getHeaders().getToPath().get(0);
                    Session session = this.findSession(localURI);
                    if (session == null) continue;
                    this.orphans.remove(orphan);
                    if (!this.connections.contains(connection)) continue;
                    try {
                        this.handleMessage(connection, request);
                    }
                    catch (IOException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("MSRP I/O error from " + connection, (Throwable)e);
                        }
                        connection.close(e);
                    }
                    catch (Exception e) {
                        this.log.error("MSRP error from " + connection, (Throwable)e);
                        connection.close(e);
                    }
                }
            }
        }
    }

    private Session findSession(MsrpUri localURI) {
        assert (localURI != null);
        Session session = this.sessionMap.get(localURI);
        if (session != null || !this.matchSessionId) {
            return session;
        }
        String sessionId = localURI.getSessionId();
        for (Session session2 : this.sessionMap.values()) {
            if (!session2.getLocalUri().getSessionId().equals(sessionId)) continue;
            return session2;
        }
        return null;
    }

    private static String dbg(Iterable<? extends SelectionKey> keys) {
        ArrayList<String> strings = new ArrayList<String>();
        for (SelectionKey selectionKey : keys) {
            strings.add(Msrp.dbg(selectionKey));
        }
        return strings.toString();
    }

    private static String dbg(SelectionKey key) {
        try {
            return "Key[interest=" + Msrp.dbgOps(key.interestOps()) + ",ready=" + Msrp.dbgOps(key.readyOps()) + ",obj=" + key.attachment() + "]";
        }
        catch (CancelledKeyException e) {
            return "Key[canceled]";
        }
    }

    private static String dbgOps(int ops) {
        StringBuilder buf = new StringBuilder(4);
        if ((ops & 0x10) != 0) {
            buf.append("A");
        }
        if ((ops & 8) != 0) {
            buf.append("C");
        }
        if ((ops & 1) != 0) {
            buf.append("R");
        }
        if ((ops & 4) != 0) {
            buf.append("W");
        }
        return buf.toString();
    }

    private static class Orphan {
        private final Connection connection;
        private final MsrpRequest request;
        private final long timestamp = System.nanoTime();

        Orphan(Connection connection, MsrpRequest request) {
            assert (connection != null);
            assert (request != null);
            this.connection = connection;
            this.request = request;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public MsrpRequest getRequest() {
            return this.request;
        }

        public long getAge() {
            return (System.nanoTime() - this.timestamp) / 1000000L;
        }
    }

    private class ServiceThread
    extends Thread {
        ServiceThread() {
            super("MSRP Service Thread for " + Msrp.this);
        }

        @Override
        public void run() {
            try {
                Msrp.this.service();
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                Msrp.this.log.error("unexpected error in service thread", t);
            }
            if (Msrp.this.log.isDebugEnabled()) {
                Msrp.this.log.debug(this + " exiting");
            }
        }
    }
}

