/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dellroad.msrp.Endpoint;

public class MsrpUri {
    private final URI uri;
    private final String sessionId;
    private final String transport;
    private final Set<String> parameters;

    public MsrpUri(String string) throws URISyntaxException {
        this.uri = new URI(string);
        String scheme = this.uri.getScheme();
        if (scheme == null) {
            throw new URISyntaxException(string, "invalid MSRP URI: no scheme");
        }
        if (!"msrp".equalsIgnoreCase(scheme) && !"msrps".equalsIgnoreCase(scheme)) {
            throw new URISyntaxException(string, "invalid MSRP URI: unknown scheme `" + scheme + "'");
        }
        if (this.uri.getAuthority() == null) {
            throw new URISyntaxException(string, "invalid MSRP URI: missing authority");
        }
        if (this.uri.getQuery() != null) {
            throw new URISyntaxException(string, "invalid MSRP URI: query string is not allowed");
        }
        if (this.uri.getFragment() != null) {
            throw new URISyntaxException(string, "invalid MSRP URI: fragment is not allowed");
        }
        String path = this.uri.getPath();
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            throw new URISyntaxException(string, "invalid MSRP URI: no path, or path does not start with `/'");
        }
        ArrayList<String> plist = new ArrayList<String>(3);
        int pos = 1;
        while (pos <= path.length()) {
            int end = path.indexOf(59, pos);
            if (end == -1) {
                end = path.length();
            }
            plist.add(path.substring(pos, end));
            pos = end + 1;
        }
        switch (plist.size()) {
            case 0: {
                throw new URISyntaxException(string, "invalid MSRP URI: no session ID specified");
            }
            case 1: {
                throw new URISyntaxException(string, "invalid MSRP URI: no transport specified");
            }
        }
        this.sessionId = (String)plist.get(0);
        this.transport = (String)plist.get(1);
        this.parameters = Collections.unmodifiableSet(new LinkedHashSet(plist.subList(2, plist.size())));
        if (!this.transport.equals("tcp")) {
            throw new URISyntaxException(string, "invalid MSRP URI: unknown transport `" + this.transport + "'");
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isSecure() {
        return "msrps".equalsIgnoreCase(this.uri.getScheme());
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getTransport() {
        return this.transport;
    }

    public Set<String> getParameters() {
        return this.parameters;
    }

    public Endpoint toEndpoint() {
        int port = this.uri.getPort();
        if (port == -1) {
            port = 2855;
        }
        return new Endpoint(this.uri.getHost(), port);
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MsrpUri that = (MsrpUri)obj;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

