/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.dellroad.msrp.FailureListener;
import org.dellroad.msrp.MsrpUri;
import org.dellroad.msrp.ReportListener;
import org.dellroad.msrp.Session;
import org.dellroad.msrp.SuccessListener;
import org.dellroad.msrp.msg.ByteRange;
import org.dellroad.msrp.msg.FailureReport;
import org.dellroad.msrp.msg.Header;
import org.dellroad.msrp.msg.MsrpHeaders;
import org.dellroad.msrp.msg.MsrpMessage;
import org.dellroad.msrp.msg.MsrpRequest;
import org.dellroad.msrp.msg.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputChunks
implements Closeable,
Iterator<MsrpRequest> {
    private static final int MAX_REQUEST_BODY_SIZE = 2048;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MsrpUri localURI;
    private final MsrpUri remoteURI;
    private final String messageId = MsrpMessage.randomId();
    private final Iterable<? extends Header> headers;
    private final InputStream input;
    private final String contentType;
    private final long size;
    private ReportListener reportListener;
    private long offset;
    private boolean complete;
    private boolean aborted;
    private boolean closed;
    private long timestamp;

    public OutputChunks(MsrpUri localURI, MsrpUri remoteURI, Iterable<? extends Header> headers, ReportListener reportListener) {
        this(localURI, remoteURI, null, -1L, null, headers, reportListener);
    }

    public OutputChunks(MsrpUri localURI, MsrpUri remoteURI, InputStream input, long size, String contentType, Iterable<? extends Header> headers, ReportListener reportListener) {
        if (localURI == null) {
            throw new IllegalArgumentException("null localURI");
        }
        if (remoteURI == null) {
            throw new IllegalArgumentException("null remoteURI");
        }
        if (input == null) {
            if (size != -1L) {
                throw new IllegalArgumentException("null input requires size = -1");
            }
            if (contentType != null) {
                throw new IllegalArgumentException("null input requires null contentType");
            }
        } else {
            if (size < -1L) {
                throw new IllegalArgumentException("invalid size " + size);
            }
            if (contentType == null) {
                throw new IllegalArgumentException("null contentType");
            }
        }
        this.localURI = localURI;
        this.remoteURI = remoteURI;
        this.input = input;
        this.size = size;
        this.contentType = contentType;
        this.reportListener = reportListener;
        this.headers = headers;
        this.timestamp = System.nanoTime();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public synchronized ReportListener getReportListener() {
        return this.reportListener;
    }

    public synchronized long getSize() {
        return this.size == -1L && this.complete ? this.offset : this.size;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    public synchronized long getIdleTime() {
        return (System.nanoTime() - this.timestamp) / 1000000L;
    }

    public synchronized void notifySuccess(final Session session, Executor executor, final ByteRange byteRange) {
        if (executor == null) {
            throw new IllegalArgumentException("null executor");
        }
        if (byteRange == null) {
            throw new IllegalArgumentException("null byteRange");
        }
        if (!(this.reportListener instanceof SuccessListener)) {
            return;
        }
        final SuccessListener successListener = (SuccessListener)this.reportListener;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    successListener.reportSuccess(session, OutputChunks.this.messageId, byteRange);
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    OutputChunks.this.log.error("error in listener notification", t);
                }
            }
        });
    }

    public synchronized void notifyFailure(final Session session, Executor executor, final Status status) {
        if (executor == null) {
            throw new IllegalArgumentException("null executor");
        }
        if (status == null) {
            throw new IllegalArgumentException("null status");
        }
        if (!(this.reportListener instanceof FailureListener)) {
            return;
        }
        final FailureListener failureListener = (FailureListener)this.reportListener;
        this.reportListener = null;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    failureListener.reportFailure(session, OutputChunks.this.messageId, status);
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    OutputChunks.this.log.error("error in listener notification", t);
                }
            }
        });
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.complete;
    }

    @Override
    public synchronized MsrpRequest next() {
        if (this.complete) {
            throw new NoSuchElementException();
        }
        this.timestamp = System.nanoTime();
        String transactionId = MsrpMessage.randomId();
        MsrpHeaders msrpHeaders = new MsrpHeaders();
        msrpHeaders.getFromPath().add(this.localURI);
        msrpHeaders.getToPath().add(this.remoteURI);
        msrpHeaders.setMessageId(this.messageId);
        msrpHeaders.setContentType(this.contentType);
        msrpHeaders.setSuccessReport(false);
        msrpHeaders.setSuccessReport(this.reportListener instanceof SuccessListener);
        if (this.reportListener instanceof FailureListener) {
            msrpHeaders.setFailureReport(FailureReport.YES);
        } else {
            msrpHeaders.setFailureReport(FailureReport.PARTIAL);
        }
        if (this.headers != null) {
            for (Header header : this.headers) {
                if (MsrpRequest.isMimeHeader(header.getName())) {
                    msrpHeaders.getMimeHeaders().add(header);
                    continue;
                }
                msrpHeaders.getExtensionHeaders().add(header);
            }
        }
        MsrpRequest request = new MsrpRequest(transactionId, "SEND", msrpHeaders);
        if (this.aborted) {
            if (this.input != null) {
                msrpHeaders.setByteRange(new ByteRange(this.offset + 1L, this.offset, this.size));
            }
            request.setAborted(true);
            this.complete = true;
            return request;
        }
        if (this.input == null) {
            this.complete = true;
            this.closed = true;
            request.setComplete(true);
            return request;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long startingOffset = this.offset;
        try {
            while (byteArrayOutputStream.size() < 2048) {
                if (this.size != -1L && this.offset >= this.size) {
                    this.complete = true;
                    break;
                }
                byte[] buf = new byte[2048 - byteArrayOutputStream.size()];
                int r = this.input.read(buf);
                if (r < 0) {
                    if (this.size != -1L) {
                        throw new IOException("expected to read " + this.size + " bytes but only read " + this.offset);
                    }
                    this.complete = true;
                    break;
                }
                byteArrayOutputStream.write(buf, 0, r);
                this.offset += (long)r;
            }
        }
        catch (IOException e) {
            this.log.error("I/O error reading MRSP message input, aborting message " + this.messageId, (Throwable)e);
            this.aborted = true;
        }
        request.setBody(byteArrayOutputStream.toByteArray());
        msrpHeaders.setByteRange(new ByteRange(startingOffset + 1L, this.offset, this.size));
        request.setComplete(this.complete);
        request.setAborted(this.aborted);
        if (this.aborted || this.complete) {
            this.close();
        }
        return request;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.complete) {
            this.aborted = true;
        }
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

