/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.dellroad.msrp.Connection;
import org.dellroad.msrp.Endpoint;
import org.dellroad.msrp.InputChunks;
import org.dellroad.msrp.Msrp;
import org.dellroad.msrp.MsrpUri;
import org.dellroad.msrp.OutputChunks;
import org.dellroad.msrp.ReportListener;
import org.dellroad.msrp.SessionListener;
import org.dellroad.msrp.msg.ByteRange;
import org.dellroad.msrp.msg.FailureReport;
import org.dellroad.msrp.msg.Header;
import org.dellroad.msrp.msg.MsrpHeaders;
import org.dellroad.msrp.msg.MsrpMessage;
import org.dellroad.msrp.msg.MsrpRequest;
import org.dellroad.msrp.msg.MsrpResponse;
import org.dellroad.msrp.msg.ProtocolException;
import org.dellroad.msrp.msg.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final int MAX_CONTENT_LENGTH = 0x1000000;
    private static final long MAX_TRANSACTION_AGE_MILLIS = 30000L;
    private static final long MAX_MESSAGE_IDLE_TIME_MILLIS = 90000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Msrp msrp;
    private final MsrpUri localURI;
    private final MsrpUri remoteURI;
    private final Endpoint activeEndpoint;
    private final SessionListener listener;
    private final Executor callbackExecutor;
    private final long startTime = System.nanoTime();
    private final TreeMap<String, InputChunks> inputChunks = new TreeMap();
    private final TreeMap<String, OutputChunks> outputChunks = new TreeMap();
    private final TreeMap<String, OutputTransaction> outputTransactions = new TreeMap();
    private final ArrayDeque<MsrpMessage> outputQueue = new ArrayDeque();
    private Connection connection;
    private boolean closed;

    Session(Msrp msrp, MsrpUri localURI, MsrpUri remoteURI, Endpoint activeEndpoint, SessionListener listener, Executor callbackExecutor) {
        this.msrp = msrp;
        this.localURI = localURI;
        this.remoteURI = remoteURI;
        this.activeEndpoint = activeEndpoint;
        this.listener = listener;
        this.callbackExecutor = callbackExecutor;
    }

    public MsrpUri getLocalUri() {
        return this.localURI;
    }

    public MsrpUri getRemoteUri() {
        return this.remoteURI;
    }

    public String toString() {
        return "Session[localURI=" + this.localURI + ",remoteURI=" + this.remoteURI + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(final Exception cause) {
        Msrp msrp = this.msrp;
        synchronized (msrp) {
            if (this.closed) {
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("closing " + this);
            }
            try {
                this.flushOutputQueue();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (OutputChunks chunks : this.outputChunks.values()) {
                chunks.close();
                if (!chunks.hasNext()) continue;
                chunks.notifyFailure(this, this.callbackExecutor, new Status(481, "Session closed"));
            }
            this.inputChunks.clear();
            this.outputChunks.clear();
            this.outputTransactions.clear();
            this.outputQueue.clear();
            this.closed = true;
            this.msrp.handleSessionClosed(this);
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.listener.sessionClosed(Session.this, cause);
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        Session.this.log.error("error in listener notification", t);
                    }
                }
            });
            return true;
        }
    }

    public String send(byte[] content, String contentType, Iterable<? extends Header> headers, ReportListener reportListener) {
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        return this.doSend(new ByteArrayInputStream(content), content.length, contentType, headers, reportListener);
    }

    public String send(InputStream input, int size, String contentType, Iterable<? extends Header> headers, ReportListener reportListener) {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        return this.doSend(input, size, contentType, headers, reportListener);
    }

    public String send(Iterable<? extends Header> headers, ReportListener reportListener) {
        return this.doSend(null, -1, null, headers, reportListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(String messageId) {
        if (messageId == null) {
            throw new IllegalArgumentException("null messageId");
        }
        Msrp msrp = this.msrp;
        synchronized (msrp) {
            OutputChunks chunks = this.outputChunks.get(messageId);
            if (chunks == null) {
                return false;
            }
            chunks.close();
            return chunks.isAborted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSuccessReport(List<MsrpUri> toPath, String messageId, ByteRange byteRange, Status status) {
        if (toPath == null || toPath.isEmpty() || toPath.get(0) == null) {
            throw new IllegalArgumentException("null/empty toPath");
        }
        if (messageId == null) {
            throw new IllegalArgumentException("null messageId");
        }
        if (byteRange == null) {
            throw new IllegalArgumentException("null byteRange");
        }
        if (status == null) {
            status = new Status(200, "Message delivered");
        }
        Msrp msrp = this.msrp;
        synchronized (msrp) {
            if (this.closed) {
                return false;
            }
            this.enqueueReport(toPath, messageId, status, byteRange);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFailureReport(List<MsrpUri> toPath, String messageId, Status status) {
        if (toPath == null || toPath.isEmpty() || toPath.get(0) == null) {
            throw new IllegalArgumentException("null/empty toPath");
        }
        if (messageId == null) {
            throw new IllegalArgumentException("null messageId");
        }
        if (status == null) {
            throw new IllegalArgumentException("null status");
        }
        Msrp msrp = this.msrp;
        synchronized (msrp) {
            if (this.closed) {
                return false;
            }
            this.enqueueReport(toPath, messageId, status, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String doSend(InputStream input, int size, String contentType, Iterable<? extends Header> headers, ReportListener reportListener) {
        Msrp msrp = this.msrp;
        synchronized (msrp) {
            if (this.closed) {
                return null;
            }
            OutputChunks chunks = new OutputChunks(this.localURI, this.remoteURI, input, size, contentType, headers, reportListener);
            String messageId = chunks.getMessageId();
            this.outputChunks.put(messageId, chunks);
            this.msrp.wakeup();
            return messageId;
        }
    }

    Connection getConnection() {
        return this.connection;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    void handleMessage(MsrpMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("null msg");
        }
        if (this.closed) {
            throw new IllegalStateException("session is closed");
        }
        if (msg instanceof MsrpRequest) {
            this.handleRequest((MsrpRequest)msg);
        } else if (msg instanceof MsrpResponse) {
            this.handleResponse((MsrpResponse)msg);
        } else {
            this.log.error("Session.handleInput(): ignoring unknown message of type " + msg.getClass().getName());
        }
    }

    private void handleRequest(MsrpRequest request) {
        switch (request.getMethod()) {
            case "SEND": {
                this.handleSend(request);
                break;
            }
            case "REPORT": {
                this.handleReport(request);
                break;
            }
            default: {
                if (!FailureReport.NO.equals((Object)request.getHeaders().getFailureReport())) {
                    this.outputQueue.add(Session.createMsrpResponse(request, 501, "Unknown method `" + request.getMethod() + "'"));
                }
                return;
            }
        }
    }

    private void handleSend(MsrpRequest request) {
        boolean complete;
        final MsrpHeaders headers = request.getHeaders();
        final String messageId = headers.getMessageId();
        InputChunks chunks0 = this.inputChunks.get(messageId);
        if (chunks0 == null) {
            chunks0 = new InputChunks(messageId, this.msrp.getMaxContentLength());
            this.inputChunks.put(messageId, chunks0);
        }
        final InputChunks chunks = chunks0;
        try {
            complete = chunks.handleSend(request);
        }
        catch (ProtocolException e) {
            this.log.debug("rec'd invalid request: " + e.getMessage());
            if (!FailureReport.NO.equals((Object)headers.getFailureReport())) {
                this.outputQueue.add(Session.createMsrpResponse(request, 400, "Protocol error: " + e.getMessage()));
            }
            return;
        }
        if (!FailureReport.NO.equals((Object)headers.getFailureReport()) && !FailureReport.PARTIAL.equals((Object)headers.getFailureReport())) {
            this.outputQueue.add(Session.createMsrpResponse(request, 200, "OK"));
        }
        if (chunks.isAborted()) {
            this.inputChunks.remove(messageId);
            return;
        }
        if (!complete) {
            return;
        }
        this.inputChunks.remove(messageId);
        final byte[] content = chunks.getContent();
        final TreeSet<Header> combinedHeaders = new TreeSet<Header>(Header.SORT_BY_NAME);
        combinedHeaders.addAll(headers.getMimeHeaders());
        combinedHeaders.addAll(headers.getExtensionHeaders());
        this.callbackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Session.this.listener.sessionReceivedMessage(Session.this, chunks.getFromPath(), messageId, content, headers.getContentType(), combinedHeaders, chunks.isSuccessReport(), FailureReport.YES.equals((Object)chunks.getFailureReport()));
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    Session.this.log.error("error in listener notification", t);
                }
            }
        });
    }

    private void handleReport(MsrpRequest request) {
        MsrpHeaders requestHeaders = request.getHeaders();
        String messageId = requestHeaders.getMessageId();
        if (messageId == null) {
            this.log.warn("rec'd REPORT with no message ID in session from " + this.remoteURI + ", ignoring");
            return;
        }
        Status status = requestHeaders.getStatus();
        if (status == null) {
            this.log.warn("rec'd REPORT with no Status in session from " + this.remoteURI + ", ignoring");
            return;
        }
        boolean success = status.getNamespace() == 0 && status.getCode() / 100 == 2;
        ByteRange byteRange = requestHeaders.getByteRange();
        if (success && byteRange == null) {
            this.log.warn("rec'd success REPORT with no ByteRange from " + this.remoteURI + ", ignoring");
            return;
        }
        OutputChunks chunks = this.outputChunks.get(messageId);
        if (chunks == null) {
            return;
        }
        if (success) {
            chunks.notifySuccess(this, this.callbackExecutor, byteRange);
        } else {
            chunks.notifyFailure(this, this.callbackExecutor, status);
        }
    }

    private void handleResponse(MsrpResponse response) {
        OutputTransaction transaction = this.outputTransactions.remove(response.getTransactionId());
        if (transaction == null) {
            return;
        }
        OutputChunks chunks = transaction.getOutputChunks();
        if (response.getCode() < 300) {
            return;
        }
        chunks.notifyFailure(this, this.callbackExecutor, response.toStatus());
        chunks.close();
        switch (response.getCode()) {
            case 481: 
            case 506: {
                this.close(new Exception("rec'd error from remote: " + response.getResultString()));
                break;
            }
        }
    }

    static MsrpResponse createMsrpResponse(MsrpRequest request, int code, String comment) {
        if (request == null) {
            throw new IllegalArgumentException("null request");
        }
        new Status(code, comment);
        MsrpHeaders requestHeaders = request.getHeaders();
        MsrpHeaders responseHeaders = new MsrpHeaders();
        if ("SEND".equals(request.getMethod())) {
            responseHeaders.getToPath().add(requestHeaders.getFromPath().get(0));
        } else {
            responseHeaders.getToPath().addAll(requestHeaders.getFromPath());
        }
        responseHeaders.getFromPath().add(requestHeaders.getToPath().get(0));
        return new MsrpResponse(request.getTransactionId(), code, comment, responseHeaders);
    }

    private void enqueueReport(List<MsrpUri> toPath, String messageId, Status status, ByteRange byteRange) {
        MsrpHeaders headers = new MsrpHeaders();
        headers.getToPath().addAll(toPath);
        headers.getFromPath().add(this.localURI);
        headers.setMessageId(messageId);
        headers.setStatus(status);
        if (byteRange != null) {
            headers.setByteRange(byteRange);
        }
        this.outputQueue.add(new MsrpRequest(MsrpMessage.randomId(), "REPORT", headers));
    }

    void performHousekeeping() throws IOException {
        long age;
        if (this.connection == null && this.activeEndpoint != null) {
            this.connection = this.msrp.createConnection(this.activeEndpoint);
        }
        if (this.connection == null && (age = (System.nanoTime() - this.startTime) / 1000000L) >= this.msrp.getConnectTimeout()) {
            throw new IOException("session not bound after " + this.msrp.getConnectTimeout() + "ms");
        }
        if (this.outputQueue.isEmpty()) {
            for (OutputChunks outputChunks : this.outputChunks.values()) {
                if (!outputChunks.hasNext()) continue;
                MsrpRequest request = outputChunks.next();
                this.outputQueue.add(request);
                this.outputTransactions.put(request.getTransactionId(), new OutputTransaction(outputChunks, request.getTransactionId()));
            }
        }
        this.flushOutputQueue();
        Iterator<Object> i = this.outputChunks.values().iterator();
        while (i.hasNext()) {
            OutputChunks outputChunks = i.next();
            if (outputChunks.hasNext() || outputChunks.getReportListener() != null && outputChunks.getIdleTime() <= 90000L) continue;
            i.remove();
        }
        i = this.inputChunks.values().iterator();
        while (i.hasNext()) {
            InputChunks inputChunks = (InputChunks)i.next();
            assert (!inputChunks.isComplete() && !inputChunks.isAborted());
            if (inputChunks.getIdleTime() <= 90000L) continue;
            if (!FailureReport.NO.equals((Object)inputChunks.getFailureReport())) {
                this.enqueueReport(inputChunks.getFromPath(), inputChunks.getMessageId(), new Status(408, "Missing message chunks never arrived"), null);
            }
            i.remove();
        }
        i = this.outputTransactions.values().iterator();
        while (i.hasNext()) {
            OutputTransaction outputTransaction = (OutputTransaction)i.next();
            if (outputTransaction.getAge() < 30000L) continue;
            outputTransaction.getOutputChunks().notifyFailure(this, this.callbackExecutor, new Status(408, "No response rec'd for transaction"));
            i.remove();
        }
    }

    private void flushOutputQueue() throws IOException {
        if (this.connection != null) {
            MsrpMessage message;
            while ((message = this.outputQueue.pollFirst()) != null) {
                this.connection.write(message);
            }
        }
    }

    private static class OutputTransaction {
        private final OutputChunks chunks;
        private final String transactionId;
        private final long sendTime;

        OutputTransaction(OutputChunks chunks, String transactionId) {
            this.chunks = chunks;
            this.transactionId = transactionId;
            this.sendTime = System.nanoTime();
        }

        public OutputChunks getOutputChunks() {
            return this.chunks;
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public long getAge() {
            return (System.nanoTime() - this.sendTime) / 1000000L;
        }
    }
}

