/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.io.ByteArrayOutputStream;
import java.util.regex.Pattern;
import org.dellroad.msrp.msg.Util;

public class BoundaryInputParser {
    private final byte[] terminator;
    private final int flagOffset;
    private boolean boundary = true;
    private int matched;

    public BoundaryInputParser(String transactionId) {
        if (transactionId == null) {
            throw new IllegalArgumentException("null transactionId");
        }
        if (!Pattern.compile("\\p{Alnum}[-\\p{Alnum}.+%=]{3,31}").matcher(transactionId).matches()) {
            throw new IllegalArgumentException("illegal transactionId");
        }
        this.terminator = ("\r\n-------" + transactionId + "?" + "\r\n").getBytes(Util.UTF8);
        this.flagOffset = 2 + "-------".length() + transactionId.length();
        assert (this.terminator[this.flagOffset] == 63);
    }

    public byte[] inputContentByte(byte b) {
        this.boundary = false;
        if (this.matched == this.flagOffset ? b == 43 || b == 36 || b == 35 : b == this.terminator[this.matched]) {
            if (this.matched == this.flagOffset) {
                this.terminator[this.flagOffset] = b;
            }
            if (++this.matched == this.terminator.length) {
                this.reset();
                return null;
            }
            return new byte[0];
        }
        if (this.matched == 0) {
            return new byte[]{b};
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(this.terminator.length);
        buf.write(this.terminator[0]);
        int offset = 1;
        block0: while (this.matched > 0) {
            for (int i = 0; i < this.matched; ++i) {
                byte next;
                byte by = next = i < this.matched - 1 ? this.terminator[offset + i] : b;
                if (this.terminator[i] == next) {
                    continue;
                }
                buf.write(--this.matched > 0 ? this.terminator[offset] : b);
                ++offset;
                continue block0;
            }
        }
        return buf.toByteArray();
    }

    public boolean isOnBoundary() {
        return this.boundary;
    }

    public void reset() {
        this.boundary = true;
        this.matched = 0;
    }

    public byte getFlagByte() {
        return this.terminator[this.flagOffset];
    }
}

