/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dellroad.msrp.msg.BoundaryInputParser;

public class BoundaryInputStream
extends FilterInputStream {
    private final BoundaryInputParser parser;
    private byte[] data;
    private int offset;
    private boolean eof;

    public BoundaryInputStream(InputStream input, String transactionId) {
        super(input);
        this.parser = new BoundaryInputParser(transactionId);
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        while (this.data == null || this.offset == this.data.length) {
            int r = super.read();
            if (r == -1) {
                throw new EOFException("detected EOF before boundary string was matched");
            }
            this.data = this.parser.inputContentByte((byte)r);
            if (this.data == null) {
                this.eof = true;
                return -1;
            }
            this.offset = 0;
        }
        return this.data[this.offset++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int total = 0;
        while (off < len) {
            int r = this.read();
            if (r == -1) {
                return total == 0 ? -1 : total;
            }
            b[off++] = (byte)r;
            ++total;
        }
        return total;
    }

    @Override
    public long skip(long n) throws IOException {
        long total = 0L;
        while (n-- > 0L && this.read() != -1) {
            ++total;
        }
        return total;
    }

    @Override
    public int available() throws IOException {
        return this.data != null ? this.data.length - this.offset : 0;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public byte getFlagByte() {
        return this.parser.getFlagByte();
    }
}

