/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dellroad.msrp.msg.Util;

public class ByteRange {
    public static final ByteRange EMPTY = new ByteRange(1L, 0L, 0L);
    public static final ByteRange ALL = new ByteRange(1L, -1L, -1L);
    private static final String BYTE_RANGE_REGEX = "([0-9]+)-(([0-9]+)|\\*)/(([0-9]+)|\\*)";
    private final long start;
    private final long end;
    private final long total;

    public ByteRange(long total) {
        this(1L, total, total);
    }

    public ByteRange(long start, long end, long total) {
        if (start < 1L) {
            throw new IllegalArgumentException("start < 1");
        }
        if (end < -1L) {
            throw new IllegalArgumentException("end < -1");
        }
        if (total < -1L) {
            throw new IllegalArgumentException("total < -1");
        }
        if (end != -1L && start - 1L > end) {
            throw new IllegalArgumentException("start - 1 > end");
        }
        if (total != -1L && end > total) {
            throw new IllegalArgumentException("end > total");
        }
        this.start = start;
        this.end = end;
        this.total = total;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getTotal() {
        return this.total;
    }

    public static ByteRange fromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        Matcher matcher = Pattern.compile(BYTE_RANGE_REGEX).matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid byte range " + Util.quotrunc(string));
        }
        try {
            long start = Long.parseLong(matcher.group(1), 10);
            long end = !matcher.group(2).equals("*") ? Long.parseLong(matcher.group(3), 10) : -1L;
            long total = !matcher.group(4).equals("*") ? Long.parseLong(matcher.group(5), 10) : -1L;
            return new ByteRange(start, end, total);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid byte range " + Util.quotrunc(string));
        }
    }

    public String toString() {
        return this.start + "-" + (this.end != -1L ? Long.valueOf(this.end) : "*") + "/" + (this.total != -1L ? Long.valueOf(this.total) : "*");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ByteRange that = (ByteRange)obj;
        return this.start == that.start && this.end == that.end && this.total == that.total;
    }

    public int hashCode() {
        return (int)(this.start << 22 ^ this.end << 11 ^ this.total);
    }
}

