/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.util.Comparator;
import java.util.regex.Pattern;

public class Header {
    public static final Comparator<Header> SORT_BY_NAME = new Comparator<Header>(){

        @Override
        public int compare(Header header1, Header header2) {
            return header1.getName().toLowerCase().compareTo(header2.getName().toLowerCase());
        }
    };
    private final String name;
    private final String value;

    public Header(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (!Pattern.compile("\\p{Alpha}[-!#$%&'*+0-9A-Za-z^_`{|}~]*").matcher(name).matches()) {
            throw new IllegalArgumentException("invalid header name `" + name + "'");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (!Pattern.compile("[\\t -\uffff]*").matcher(value).matches()) {
            throw new IllegalArgumentException("invalid header value `" + value + "'");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Header that = (Header)obj;
        return this.name.equals(that.name) && this.value.equals(that.value);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.value.hashCode();
    }
}

