/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.io.ByteArrayOutputStream;
import org.dellroad.msrp.msg.ProtocolException;
import org.dellroad.msrp.msg.Util;

public class LineInputParser {
    private final int maxLength;
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private boolean pendingCR;

    public LineInputParser(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength < 0");
        }
        this.maxLength = maxLength;
    }

    public String inputLineByte(byte b) throws ProtocolException {
        if (this.pendingCR) {
            if (b == 10) {
                String line = new String(this.buf.toByteArray(), Util.UTF8);
                this.reset();
                return line;
            }
            this.buf.write(13);
        }
        boolean bl = this.pendingCR = b == 13;
        if (!this.pendingCR) {
            this.buf.write(b);
        }
        if (this.buf.size() >= this.maxLength) {
            String prefix = new String(this.buf.toByteArray(), 0, 40, Util.UTF8);
            throw new ProtocolException("message line starting with " + Util.quotrunc(prefix) + " is too long (longer than " + this.maxLength + " bytes)");
        }
        return null;
    }

    public boolean isBetweenLines() {
        return this.buf.size() == 0 && !this.pendingCR;
    }

    public void reset() {
        this.buf.reset();
        this.pendingCR = false;
    }
}

