/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dellroad.msrp.MsrpUri;
import org.dellroad.msrp.msg.ByteRange;
import org.dellroad.msrp.msg.FailureReport;
import org.dellroad.msrp.msg.Header;
import org.dellroad.msrp.msg.Status;

public class MsrpHeaders {
    private final ArrayList<MsrpUri> toPath = new ArrayList();
    private final ArrayList<MsrpUri> fromPath = new ArrayList();
    private String messageId;
    private boolean successReport;
    private FailureReport failureReport = FailureReport.YES;
    private ByteRange byteRange;
    private Status status;
    private String contentType;
    private final TreeSet<Header> extensionHeaders = new TreeSet<Header>(Header.SORT_BY_NAME);
    private final TreeSet<Header> mimeHeaders = new TreeSet<Header>(Header.SORT_BY_NAME);

    public List<MsrpUri> getToPath() {
        return this.toPath;
    }

    public List<MsrpUri> getFromPath() {
        return this.fromPath;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public boolean isSuccessReport() {
        return this.successReport;
    }

    public void setSuccessReport(boolean successReport) {
        this.successReport = successReport;
    }

    public FailureReport getFailureReport() {
        return this.failureReport;
    }

    public void setFailureReport(FailureReport failureReport) {
        this.failureReport = failureReport;
    }

    public ByteRange getByteRange() {
        return this.byteRange;
    }

    public void setByteRange(ByteRange byteRange) {
        this.byteRange = byteRange;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public SortedSet<Header> getMimeHeaders() {
        return this.mimeHeaders;
    }

    public SortedSet<Header> getExtensionHeaders() {
        return this.extensionHeaders;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MsrpHeaders that = (MsrpHeaders)obj;
        if (!this.toPath.equals(that.toPath)) {
            return false;
        }
        if (!this.fromPath.equals(that.fromPath)) {
            return false;
        }
        if (!(this.messageId == null ? that.messageId == null : this.messageId.equals(that.messageId))) {
            return false;
        }
        if (this.successReport != that.successReport) {
            return false;
        }
        if (this.failureReport != that.failureReport) {
            return false;
        }
        if (!(this.byteRange == null ? that.byteRange == null : this.byteRange.equals(that.byteRange))) {
            return false;
        }
        if (!(this.status == null ? that.status == null : this.status.equals(that.status))) {
            return false;
        }
        if (!(this.contentType == null ? that.contentType == null : this.contentType.equals(that.contentType))) {
            return false;
        }
        if (!this.extensionHeaders.equals(that.extensionHeaders)) {
            return false;
        }
        return this.mimeHeaders.equals(that.mimeHeaders);
    }

    public int hashCode() {
        return this.toPath.hashCode() ^ this.fromPath.hashCode() ^ (this.messageId != null ? this.messageId.hashCode() : 0) ^ (this.successReport ? 1 : 0) ^ (this.failureReport != null ? this.failureReport.hashCode() : 0) ^ (this.byteRange != null ? this.byteRange.hashCode() : 0) ^ (this.status != null ? this.status.hashCode() : 0) ^ (this.contentType != null ? this.contentType.hashCode() : 0) ^ this.extensionHeaders.hashCode() ^ this.mimeHeaders.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (!this.toPath.isEmpty()) {
            buf.append("To-Path").append(": ");
            for (MsrpUri uri : this.toPath) {
                buf.append(uri);
            }
            buf.append("\r\n");
        }
        if (!this.toPath.isEmpty()) {
            buf.append("From-Path").append(": ");
            for (MsrpUri uri : this.fromPath) {
                buf.append(uri);
            }
            buf.append("\r\n");
        }
        if (this.messageId != null) {
            buf.append("Message-ID").append(": ").append(this.messageId).append("\r\n");
        }
        if (this.successReport) {
            buf.append("Success-Report").append(": ").append("yes").append("\r\n");
        }
        if (this.failureReport != null && this.failureReport != FailureReport.YES) {
            buf.append("Failure-Report").append(": ").append((Object)this.failureReport).append("\r\n");
        }
        if (this.byteRange != null) {
            buf.append("Byte-Range").append(": ").append(this.byteRange).append("\r\n");
        }
        if (this.status != null) {
            buf.append("Status").append(": ").append(this.status).append("\r\n");
        }
        for (Header header : this.extensionHeaders) {
            buf.append(header).append("\r\n");
        }
        for (Header header : this.mimeHeaders) {
            buf.append(header).append("\r\n");
        }
        if (this.contentType != null) {
            buf.append("Content-Type").append(": ").append(this.contentType).append("\r\n");
        }
        return buf.toString();
    }
}

