/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.io.ByteArrayOutputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dellroad.msrp.MsrpUri;
import org.dellroad.msrp.msg.BoundaryInputParser;
import org.dellroad.msrp.msg.ByteRange;
import org.dellroad.msrp.msg.FailureReport;
import org.dellroad.msrp.msg.Header;
import org.dellroad.msrp.msg.LineInputParser;
import org.dellroad.msrp.msg.MsrpMessage;
import org.dellroad.msrp.msg.MsrpRequest;
import org.dellroad.msrp.msg.MsrpResponse;
import org.dellroad.msrp.msg.ProtocolException;
import org.dellroad.msrp.msg.Status;
import org.dellroad.msrp.msg.Util;

public class MsrpInputParser {
    public static final int DEFAULT_MAX_LINE_LENGTH = 16384;
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0x1000000;
    public static final int DEFAULT_MAX_PATH_URIS = 32;
    public static final int DEFAULT_MAX_MIME_HEADERS = 16;
    public static final int DEFAULT_MAX_EXTENSION_HEADERS = 32;
    private static final Pattern REQUEST_LINE_PATTERN = Pattern.compile("MSRP ([-.+%=\\p{Alnum}]{3,31}) ([A-Z]+)");
    private static final Pattern RESPONSE_LINE_PATTERN = Pattern.compile("MSRP ([-.+%=\\p{Alnum}]{3,31}) ([0-9]{3})( (.*))?");
    private static final Header HEADER_EOF = new Header("dummy", "dummy");
    private final LineInputParser lineParser;
    private final int maxBodySize;
    private final int maxPathUris;
    private final int maxMimeHeaders;
    private final int maxExtensionHeaders;
    private State state = State.FIRST_LINE;
    private MsrpMessage message;
    private String endLine;
    private boolean allowBody;
    private ByteArrayOutputStream body;
    private BoundaryInputParser boundaryInputParser;

    public MsrpInputParser() {
        this(16384, 0x1000000, 32, 16, 32);
    }

    public MsrpInputParser(int maxLineLength, int maxBodySize, int maxPathUris, int maxMimeHeaders, int maxExtensionHeaders) {
        this.lineParser = new LineInputParser(maxLineLength);
        this.maxBodySize = maxBodySize;
        this.maxPathUris = maxPathUris;
        this.maxMimeHeaders = maxMimeHeaders;
        this.maxExtensionHeaders = maxExtensionHeaders;
    }

    public MsrpMessage inputMessageByte(byte b) throws ProtocolException {
        boolean complete = false;
        switch (this.state) {
            case FIRST_LINE: {
                this.inputFirstLineByte(b);
                break;
            }
            case TO_PATH: {
                if (!this.inputPathHeaderByte(this.message.getHeaders().getToPath(), "To-Path", b)) break;
                this.state = State.FROM_PATH;
                break;
            }
            case FROM_PATH: {
                if (!this.inputPathHeaderByte(this.message.getHeaders().getFromPath(), "From-Path", b)) break;
                this.state = State.HEADER;
                break;
            }
            case HEADER: {
                complete = this.inputHeaderByte(b);
                break;
            }
            case BODY_CONTENT: {
                complete = this.inputBodyContentByte(b);
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        if (complete) {
            MsrpMessage result = this.message;
            this.reset();
            return result;
        }
        return null;
    }

    public void reset() {
        this.lineParser.reset();
        this.state = State.FIRST_LINE;
        this.message = null;
        this.endLine = null;
        this.allowBody = false;
        this.body = null;
        this.boundaryInputParser = null;
    }

    public boolean isBetweenMessages() {
        return this.state == State.FIRST_LINE && this.lineParser.isBetweenLines();
    }

    private void inputFirstLineByte(byte b) throws ProtocolException {
        String line = this.lineParser.inputLineByte(b);
        if (line == null) {
            return;
        }
        Matcher matcher = REQUEST_LINE_PATTERN.matcher(line);
        if (matcher.matches()) {
            this.message = new MsrpRequest(matcher.group(1), matcher.group(2), null);
        } else {
            matcher = RESPONSE_LINE_PATTERN.matcher(line);
            if (matcher.matches()) {
                this.message = new MsrpResponse(matcher.group(1), Integer.parseInt(matcher.group(2), 10), matcher.group(4), null);
            } else {
                throw new ProtocolException("invalid start line " + Util.quotrunc(line));
            }
        }
        this.endLine = "-------" + this.message.getTransactionId();
        this.allowBody = this.message instanceof MsrpRequest;
        this.state = State.TO_PATH;
    }

    private boolean inputHeaderByte(byte b) throws ProtocolException {
        Header header = this.inputHeaderByteForHeader(b);
        if (header == null) {
            return false;
        }
        if (header == HEADER_EOF) {
            if (this.body != null && !this.allowBody) {
                throw new ProtocolException("message must not contain a body but does");
            }
            if (this.body == null) {
                return true;
            }
            this.boundaryInputParser = new BoundaryInputParser(this.message.getTransactionId());
            this.state = State.BODY_CONTENT;
            return false;
        }
        String name = header.getName();
        String value = header.getValue();
        if (name.equalsIgnoreCase("Message-ID")) {
            if (!Pattern.compile("\\p{Alnum}[-\\p{Alnum}.+%=]{3,31}").matcher(value).matches()) {
                throw new ProtocolException("invalid `" + name + "' header value " + Util.quotrunc(value));
            }
            this.message.getHeaders().setMessageId(value);
        } else if (name.equalsIgnoreCase("Success-Report")) {
            switch (value) {
                case "yes": {
                    this.message.getHeaders().setSuccessReport(true);
                    break;
                }
                case "no": {
                    this.message.getHeaders().setSuccessReport(false);
                    break;
                }
                default: {
                    throw new ProtocolException("invalid `" + name + "' header value " + Util.quotrunc(value));
                }
            }
        } else if (name.equalsIgnoreCase("Failure-Report")) {
            switch (value) {
                case "yes": {
                    this.message.getHeaders().setFailureReport(FailureReport.YES);
                    break;
                }
                case "no": {
                    this.message.getHeaders().setFailureReport(FailureReport.NO);
                    break;
                }
                case "partial": {
                    this.message.getHeaders().setFailureReport(FailureReport.PARTIAL);
                    break;
                }
                default: {
                    throw new ProtocolException("invalid `" + name + "' header value " + Util.quotrunc(value));
                }
            }
        } else if (name.equalsIgnoreCase("Byte-Range")) {
            try {
                this.message.getHeaders().setByteRange(ByteRange.fromString(value));
            }
            catch (IllegalArgumentException e) {
                throw new ProtocolException("invalid `" + name + "' header value " + Util.quotrunc(value));
            }
        } else if (name.equalsIgnoreCase("Status")) {
            try {
                this.message.getHeaders().setStatus(Status.fromString(value));
            }
            catch (IllegalArgumentException e) {
                throw new ProtocolException("invalid `" + name + "' header value " + Util.quotrunc(value));
            }
        } else if (name.equalsIgnoreCase("Content-Type")) {
            this.message.getHeaders().setContentType(value);
        } else if (MsrpRequest.isMimeHeader(name)) {
            this.message.getHeaders().getMimeHeaders().remove(header);
            if (this.message.getHeaders().getMimeHeaders().size() >= this.maxMimeHeaders) {
                throw new ProtocolException("too many MIME headers (maximum " + this.maxMimeHeaders + ")");
            }
            this.message.getHeaders().getMimeHeaders().add(header);
        } else {
            this.message.getHeaders().getExtensionHeaders().remove(header);
            if (this.message.getHeaders().getExtensionHeaders().size() >= this.maxExtensionHeaders) {
                throw new ProtocolException("too many extension headers (maximum " + this.maxExtensionHeaders + ")");
            }
            this.message.getHeaders().getExtensionHeaders().add(header);
        }
        return false;
    }

    private boolean inputBodyContentByte(byte b) throws ProtocolException {
        byte[] data = this.boundaryInputParser.inputContentByte(b);
        if (data != null) {
            this.body.write(data, 0, data.length);
            if (this.body.size() > this.maxBodySize) {
                throw new ProtocolException("body size exceeds maximum size limit (" + this.maxBodySize + " bytes)");
            }
            return false;
        }
        MsrpRequest request = (MsrpRequest)this.message;
        request.setBody(this.body.toByteArray());
        switch (this.boundaryInputParser.getFlagByte()) {
            case 43: {
                request.setComplete(false);
                request.setAborted(false);
                break;
            }
            case 36: {
                request.setComplete(true);
                break;
            }
            case 35: {
                request.setAborted(true);
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        return true;
    }

    private boolean inputPathHeaderByte(List<MsrpUri> uriList, String name, byte b) throws ProtocolException {
        String paths = this.inputRequiredHeaderByte(name, b);
        if (paths == null) {
            return false;
        }
        if (paths.length() == 0) {
            throw new ProtocolException("invalid empty `" + name + "' header");
        }
        int start = 0;
        while (start < paths.length()) {
            int end = paths.indexOf(32, start);
            if (end == -1) {
                end = paths.length();
            }
            String uri = paths.substring(start, end);
            if (uriList.size() >= this.maxPathUris) {
                throw new ProtocolException("too many URI's in `" + name + "' header (maximum " + this.maxPathUris + ")");
            }
            try {
                uriList.add(new MsrpUri(uri));
            }
            catch (URISyntaxException e) {
                throw new ProtocolException("invalid URI " + Util.quotrunc(uri) + " in `" + name + "' header", e);
            }
            start = end;
        }
        return true;
    }

    private String inputRequiredHeaderByte(String name, byte b) throws ProtocolException {
        Header header = this.inputHeaderByteForHeader(b);
        if (header == null) {
            return null;
        }
        if (header == HEADER_EOF) {
            throw new ProtocolException("missing required `" + name + "' header");
        }
        if (!header.getName().equalsIgnoreCase(name)) {
            throw new ProtocolException("expected required `" + name + "' header but found " + Util.quotrunc(header.getName()) + " header instead");
        }
        return header.getValue();
    }

    private Header inputHeaderByteForHeader(byte b) throws ProtocolException {
        String line = this.lineParser.inputLineByte(b);
        if (line == null) {
            return null;
        }
        assert (this.endLine != null);
        if (line.startsWith(this.endLine) && line.length() == this.endLine.length() + 1) {
            char flag = line.charAt(this.endLine.length());
            if (flag != '$') {
                throw new ProtocolException("invalid end-line flag byte `" + flag + "' in message without body");
            }
            this.body = null;
            return HEADER_EOF;
        }
        if (line.length() == 0) {
            this.body = new ByteArrayOutputStream();
            return HEADER_EOF;
        }
        Matcher matcher = Pattern.compile("(\\p{Alpha}[-!#$%&'*+0-9A-Za-z^_`{|}~]*): ([\\t -\uffff]*)").matcher(line);
        if (!matcher.matches()) {
            throw new ProtocolException("invalid header line " + Util.quotrunc(line));
        }
        return new Header(matcher.group(1), matcher.group(2));
    }

    private static enum State {
        FIRST_LINE,
        TO_PATH,
        FROM_PATH,
        HEADER,
        BODY_CONTENT;

    }
}

