/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dellroad.msrp.msg.MsrpInputParser;
import org.dellroad.msrp.msg.MsrpMessage;

public class MsrpInputStream
extends FilterInputStream {
    private final MsrpInputParser parser;

    public MsrpInputStream(InputStream input) {
        this(input, new MsrpInputParser());
    }

    public MsrpInputStream(InputStream input, MsrpInputParser parser) {
        super(input);
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (parser == null) {
            throw new IllegalArgumentException("null parser");
        }
        this.parser = parser;
    }

    public MsrpInputParser getParser() {
        return this.parser;
    }

    public MsrpMessage readMsrpMessage() throws IOException {
        int b;
        MsrpMessage result;
        do {
            if ((b = this.read()) != -1) continue;
            if (!this.parser.isBetweenMessages()) {
                throw new EOFException("truncated message");
            }
            return null;
        } while ((result = this.parser.inputMessageByte((byte)b)) == null);
        return result;
    }
}

