/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.dellroad.msrp.msg.MsrpHeaders;
import org.dellroad.msrp.msg.Util;

public abstract class MsrpMessage {
    private final String transactionId;
    private final MsrpHeaders headers;

    protected MsrpMessage() {
        this(null, null);
    }

    protected MsrpMessage(String transactionId, MsrpHeaders headers) {
        String string = this.transactionId = transactionId != null ? transactionId : MsrpMessage.randomId();
        if (!Pattern.compile("\\p{Alnum}[-\\p{Alnum}.+%=]{3,31}").matcher(this.transactionId).matches()) {
            throw new IllegalArgumentException("invalid transaction ID `" + this.transactionId + "'");
        }
        this.headers = headers != null ? headers : new MsrpHeaders();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public MsrpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] encode(boolean withBody) {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            OutputStreamWriter bufWriter = new OutputStreamWriter((OutputStream)buf, Util.UTF8);
            bufWriter.write(this.getFirstLine());
            bufWriter.write("\r\n");
            bufWriter.write(this.headers.toString());
            bufWriter.flush();
            if (withBody) {
                this.writePayload(buf);
            }
            bufWriter.write("-------");
            bufWriter.write(this.transactionId);
            bufWriter.write(this.getFlagByte() & 0xFF);
            bufWriter.write("\r\n");
            bufWriter.flush();
            return buf.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception");
        }
    }

    public static String randomId() {
        return String.format("%016x", ThreadLocalRandom.current().nextLong());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MsrpMessage that = (MsrpMessage)obj;
        if (!(this.transactionId == null ? that.transactionId == null : this.transactionId.equals(that.transactionId))) {
            return false;
        }
        return this.headers == null ? that.headers == null : this.headers.equals(that.headers);
    }

    public int hashCode() {
        return (this.transactionId != null ? this.transactionId.hashCode() : 0) ^ (this.headers != null ? this.headers.hashCode() : 0);
    }

    public String toString() {
        return new String(this.encode(false), Util.UTF8);
    }

    protected abstract byte getFlagByte();

    protected abstract String getFirstLine();

    protected abstract void writePayload(OutputStream var1) throws IOException;
}

