/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.dellroad.msrp.msg.FailureReport;
import org.dellroad.msrp.msg.MsrpHeaders;
import org.dellroad.msrp.msg.MsrpMessage;
import org.dellroad.msrp.msg.MsrpResponse;
import org.dellroad.msrp.msg.ProtocolException;

public class MsrpRequest
extends MsrpMessage {
    private final String method;
    private byte[] body;
    private boolean complete = true;
    private boolean aborted;

    public MsrpRequest(String method) {
        this(null, method, null);
    }

    public MsrpRequest(String transactionId, String method, MsrpHeaders headers) {
        this(transactionId, method, headers, null);
    }

    public MsrpRequest(String transactionId, String method, MsrpHeaders headers, byte[] body) {
        super(transactionId, headers);
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        if (!Pattern.compile("[A-Z]+").matcher(method).matches()) {
            throw new IllegalArgumentException("invalid method `" + method + "'");
        }
        this.method = method;
        this.body = body;
    }

    public String getMethod() {
        return this.method;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public MsrpResponse buildResponse(int code, String comment) {
        if (FailureReport.NO.equals((Object)this.getHeaders().getFailureReport())) {
            return null;
        }
        MsrpHeaders responseHeaders = new MsrpHeaders();
        if (this.getMethod().equals("SEND")) {
            responseHeaders.getToPath().add(this.getHeaders().getFromPath().get(0));
        } else {
            responseHeaders.getToPath().addAll(this.getHeaders().getFromPath());
        }
        responseHeaders.getFromPath().add(this.getHeaders().getToPath().get(0));
        return new MsrpResponse(this.getTransactionId(), code, comment, responseHeaders);
    }

    public void validate() throws ProtocolException {
        if (this.body != null && this.getHeaders().getContentType() == null) {
            throw new ProtocolException("missing header `Content-Type' required when message has a body");
        }
        if (!(this.body != null || this.getHeaders().getContentType() == null && this.getHeaders().getMimeHeaders().isEmpty())) {
            throw new ProtocolException("MIME headers are not allowed when message has no body");
        }
    }

    public static boolean isMimeHeader(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        String prefix = "Content-";
        return name.regionMatches(true, 0, "Content-", 0, "Content-".length());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MsrpRequest that = (MsrpRequest)obj;
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (!(this.body == null ? that.body == null : that.body != null && Arrays.equals(this.body, that.body))) {
            return false;
        }
        if (this.complete != that.complete) {
            return false;
        }
        return this.aborted == that.aborted;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.method.hashCode() ^ (this.body != null ? Arrays.hashCode(this.body) : 0) ^ (this.complete ? 1 : 0) ^ (this.aborted ? 2 : 0);
    }

    @Override
    public byte getFlagByte() {
        return (byte)(this.aborted ? 35 : (this.complete ? 36 : 43));
    }

    @Override
    protected String getFirstLine() {
        return "MSRP " + this.getTransactionId() + " " + this.method;
    }

    @Override
    protected void writePayload(OutputStream output) throws IOException {
        if (this.body != null) {
            output.write(13);
            output.write(10);
            output.write(this.body);
            output.write(13);
            output.write(10);
        }
    }
}

