/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.io.IOException;
import java.io.OutputStream;
import org.dellroad.msrp.msg.MsrpHeaders;
import org.dellroad.msrp.msg.MsrpMessage;
import org.dellroad.msrp.msg.Status;

public class MsrpResponse
extends MsrpMessage {
    private final int code;
    private final String comment;

    public MsrpResponse(String transactionId, int code, String comment) {
        this(transactionId, code, comment, null);
    }

    public MsrpResponse(String transactionId, int code, String comment, MsrpHeaders headers) {
        super(transactionId, headers);
        if (code < 0 || code > 999) {
            throw new IllegalArgumentException("invalid code " + code);
        }
        this.code = code;
        this.comment = comment;
    }

    public int getCode() {
        return this.code;
    }

    public String getComment() {
        return this.comment;
    }

    public String getResultString() {
        return String.format("%03d%s", this.code, this.comment != null ? " " + this.comment : "");
    }

    public Status toStatus() {
        return new Status(this.code, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MsrpResponse that = (MsrpResponse)obj;
        if (this.code != that.code) {
            return false;
        }
        return this.comment == null ? that.comment == null : this.comment.equals(that.comment);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.code ^ (this.comment != null ? this.comment.hashCode() : 0);
    }

    @Override
    public byte getFlagByte() {
        return 36;
    }

    @Override
    protected String getFirstLine() {
        return "MSRP " + this.getTransactionId() + " " + this.getResultString();
    }

    @Override
    protected void writePayload(OutputStream output) throws IOException {
    }
}

