/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.msrp.msg;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dellroad.msrp.msg.Util;

public class Status {
    private static final String STATUS_REGEX = "([0-9]{3}) ([0-9]{3})( (.*))?";
    private final int namespace;
    private final int code;
    private final String comment;

    public Status(int code, String comment) {
        this(0, code, comment);
    }

    public Status(int namespace, int code) {
        this(namespace, code, null);
    }

    public Status(int namespace, int code, String comment) {
        if (namespace < 0 || namespace > 999) {
            throw new IllegalArgumentException("invalid namespace " + namespace);
        }
        if (code < 0 || code > 999) {
            throw new IllegalArgumentException("invalid code " + code);
        }
        this.namespace = namespace;
        this.code = code;
        this.comment = comment;
    }

    public int getNamespace() {
        return this.namespace;
    }

    public int getCode() {
        return this.code;
    }

    public String getComment() {
        return this.comment;
    }

    public static Status fromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        Matcher matcher = Pattern.compile(STATUS_REGEX).matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid status " + Util.quotrunc(string));
        }
        try {
            int namespace = Integer.parseInt(matcher.group(1), 10);
            int code = Integer.parseInt(matcher.group(2), 10);
            return new Status(namespace, code, matcher.group(4));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid status " + Util.quotrunc(string));
        }
    }

    public String toString() {
        return String.format("%03d %03d%s", this.namespace, this.code, this.comment != null ? " " + this.comment : "");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Status that = (Status)obj;
        return this.namespace == that.namespace && this.code == that.code && (this.comment != null ? this.comment.equals(that.comment) : that.comment == null);
    }

    public int hashCode() {
        return this.namespace << 16 ^ this.code << 8 ^ (this.comment != null ? this.comment.hashCode() : 0);
    }
}

