/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.querystream.test.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class CapturePrintStream
extends PrintStream {
    private ByteArrayOutputStream buf;

    public CapturePrintStream(PrintStream out, boolean autoFlush, String charset) throws UnsupportedEncodingException {
        super((OutputStream)out, autoFlush, charset);
    }

    public static CapturePrintStream of(PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException("null out");
        }
        try {
            return new CapturePrintStream(out, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("unexpected error", e);
        }
    }

    public synchronized boolean startCapture() {
        if (this.buf != null) {
            return false;
        }
        this.buf = new ByteArrayOutputStream();
        return true;
    }

    public synchronized byte[] stopCapture() {
        if (this.buf == null) {
            return null;
        }
        byte[] capture = this.buf.toByteArray();
        this.buf = null;
        return capture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CapturePrintStream capturePrintStream = this;
        synchronized (capturePrintStream) {
            this.buf = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        super.write(b);
        CapturePrintStream capturePrintStream = this;
        synchronized (capturePrintStream) {
            if (this.buf != null) {
                this.buf.write(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) {
        super.write(buf, off, len);
        CapturePrintStream capturePrintStream = this;
        synchronized (capturePrintStream) {
            if (this.buf != null) {
                this.buf.write(buf, off, len);
            }
        }
    }
}

