
    drop table Department if exists;

    drop table Employee if exists;

    drop table Employee_annotations if exists;

    create table Department (
        id bigint generated by default as identity,
        name varchar(255),
        primary key (id)
    );

    create table Employee (
        id bigint generated by default as identity,
        name varchar(255),
        salary float(24) not null,
        seniority varchar(255) check (seniority in ('JUNIOR','SENIOR')),
        startDate timestamp(6),
        department_id bigint,
        manager_id bigint,
        primary key (id)
    );

    create table Employee_annotations (
        Employee_id bigint not null,
        "value" varchar(65535) not null,
        name varchar(180) not null,
        primary key (Employee_id, name)
    );

    alter table Employee 
       add constraint FK14tijxqry9ml17nk86sqfp561 
       foreign key (department_id) 
       references Department;

    alter table Employee 
       add constraint FKiralam2duuhr33k8a10aoc2t6 
       foreign key (manager_id) 
       references Employee;

    alter table Employee_annotations 
       add constraint FKjv16js9s8j8ef4nu2bdkw0cml 
       foreign key (Employee_id) 
       references Employee;
