/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.chain.icp.brasil.provider.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.demoiselle.signer.chain.icp.brasil.provider.impl.ICPBrasilProviderCAException;
import org.demoiselle.signer.core.ca.provider.ProviderCA;
import org.demoiselle.signer.core.util.MessagesBundle;

public class ICPBrasilProviderCA
implements ProviderCA {
    private static MessagesBundle chainMessagesBundle = new MessagesBundle();

    public Collection<X509Certificate> getCAs() {
        KeyStore keyStore = this.getKeyStore();
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate root = (X509Certificate)keyStore.getCertificate(alias);
                result.add(root);
            }
        }
        catch (KeyStoreException ex) {
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.load.keystore"), ex);
        }
        return result;
    }

    private KeyStore getKeyStore() {
        KeyStore keyStore = null;
        try {
            InputStream is = ICPBrasilProviderCA.class.getClassLoader().getResourceAsStream("icpbrasil.jks");
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(is, "changeit".toCharArray());
        }
        catch (KeyStoreException ex) {
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.load.keystore"), ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.no.algorithm"), ex);
        }
        catch (CertificateException ex) {
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.jks.certificate"), ex);
        }
        catch (IOException ex) {
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.io"), ex);
        }
        return keyStore;
    }

    public String getName() {
        return chainMessagesBundle.getString("info.provider.name.demoiselle");
    }
}

