/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.chain.icp.brasil.provider.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.demoiselle.signer.chain.icp.brasil.provider.ChainICPBrasilConfig;
import org.demoiselle.signer.chain.icp.brasil.provider.impl.ICPBrasilUserHomeProviderCA;
import org.demoiselle.signer.core.ca.provider.ProviderCA;
import org.demoiselle.signer.core.util.Downloads;
import org.demoiselle.signer.core.util.MessagesBundle;

public class ICPBrasilOnLineSerproProviderCA
implements ProviderCA {
    private static final String STRING_URL_ZIP = ChainICPBrasilConfig.getInstance().getUrl_local_ac_list();
    private static final String STRING_URL_HASH = ChainICPBrasilConfig.getInstance().getUrl_local_ac_list_sha512();
    private static final Logger LOGGER = Logger.getLogger(ICPBrasilOnLineSerproProviderCA.class);
    protected static MessagesBundle chainMessagesBundle = new MessagesBundle();

    public String getURLZIP() {
        return STRING_URL_ZIP;
    }

    public String getURLHash() {
        return STRING_URL_HASH;
    }

    public Collection<X509Certificate> getCAs() {
        Collection<X509Certificate> result = null;
        boolean useCache = false;
        try {
            Path pathZip = ICPBrasilUserHomeProviderCA.FULL_PATH_ZIP;
            if (Files.exists(pathZip, new LinkOption[0])) {
                InputStream inputStreamHash = Downloads.getInputStreamFromURL((String)this.getURLHash());
                Scanner scannerOnlineHash = new Scanner(inputStreamHash);
                scannerOnlineHash.useDelimiter("\\A");
                String onlineHash = scannerOnlineHash.hasNext() ? scannerOnlineHash.next() : "";
                scannerOnlineHash.close();
                if (!onlineHash.equals("")) {
                    String localZipHash = DatatypeConverter.printHexBinary((byte[])this.checksum(new File(pathZip.toString())));
                    String onlineHashWithouFilename = onlineHash.replace("ACcompactado.zip", "").replaceAll(" ", "").replaceAll("\n", "");
                    useCache = onlineHashWithouFilename.equalsIgnoreCase(localZipHash);
                } else {
                    LOGGER.warn((Object)chainMessagesBundle.getString("error.hash.empty"));
                }
            }
            if (!useCache) {
                LOGGER.debug((Object)chainMessagesBundle.getString("info.file.downloading", new Object[]{this.getURLZIP()}));
                InputStream inputStreamZip = Downloads.getInputStreamFromURL((String)this.getURLZIP());
                Files.copy(inputStreamZip, pathZip, StandardCopyOption.REPLACE_EXISTING);
                inputStreamZip.close();
                LOGGER.debug((Object)chainMessagesBundle.getString("info.sucess"));
            }
            FileInputStream inputStreamZipReturn = new FileInputStream(pathZip.toString());
            result = this.getFromZip(inputStreamZipReturn);
            ((InputStream)inputStreamZipReturn).close();
            LOGGER.debug((Object)chainMessagesBundle.getString("info.recovered.certs", new Object[]{result.size()}));
        }
        catch (IOException e) {
            LOGGER.warn((Object)(chainMessagesBundle.getString("error.recover.file") + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.warn((Object)(chainMessagesBundle.getString("error.exception.recorver.chain") + e.getMessage()));
        }
        if (result != null) {
            LOGGER.debug((Object)chainMessagesBundle.getString("info.number.certificates.found", new Object[]{this.getName(), result.size()}));
        } else {
            LOGGER.info((Object)chainMessagesBundle.getString("info.none.certificates", new Object[]{this.getName()}));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] checksum(File input) {
        try (FileInputStream in = new FileInputStream(input);){
            int length;
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] block = new byte[4096];
            while ((length = ((InputStream)in).read(block)) > 0) {
                digest.update(block, 0, length);
            }
            byte[] byArray = digest.digest();
            return byArray;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<X509Certificate> getOnline(InputStream zip) {
        HashSet<X509Certificate> result = new HashSet();
        long timeBefore = 0L;
        long timeAfter = 0L;
        try {
            timeBefore = System.currentTimeMillis();
            result = this.getFromZip(zip);
            timeAfter = System.currentTimeMillis();
        }
        catch (Throwable error) {
            try {
                timeAfter = System.currentTimeMillis();
                LOGGER.warn((Object)chainMessagesBundle.getString("error.throwable", new Object[]{error.getMessage()}));
            }
            catch (Throwable throwable) {
                LOGGER.debug((Object)chainMessagesBundle.getString("info.time.total", new Object[]{timeAfter - timeBefore}));
                throw throwable;
            }
            LOGGER.debug((Object)chainMessagesBundle.getString("info.time.total", new Object[]{timeAfter - timeBefore}));
        }
        LOGGER.debug((Object)chainMessagesBundle.getString("info.time.total", new Object[]{timeAfter - timeBefore}));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<X509Certificate> getFromZip(InputStream zip) throws RuntimeException {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>();
        BufferedInputStream in = new BufferedInputStream(zip);
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry localFile = null;
        try {
            while ((localFile = zin.getNextEntry()) != null) {
                try {
                    if (localFile.isDirectory()) continue;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] b = new byte[512];
                    int len = 0;
                    while ((len = zin.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
                    out.close();
                    X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(is);
                    is.close();
                    result.add(certificate);
                }
                catch (CertificateException error) {
                    LOGGER.error((Object)(chainMessagesBundle.getString("error.invalid.certificate") + error.getMessage()));
                }
            }
            return result;
        }
        catch (IOException error) {
            LOGGER.error((Object)(chainMessagesBundle.getString("error.stream") + error.getMessage()));
            throw new RuntimeException(chainMessagesBundle.getString("error.stream"), error);
        }
    }

    public String getName() {
        return chainMessagesBundle.getString("info.provider.name.serpro", new Object[]{this.getURLZIP()});
    }
}

