/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.chain.icp.brasil.provider.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.demoiselle.signer.core.ca.provider.ProviderCA;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICPBrasilUserHomeProviderCA
implements ProviderCA {
    public static final String PATH_HOME_USER = System.getProperty("user.home");
    public static final String FOLDER_SIGNER = ".java" + File.separator + "signer";
    public static final String FILENAME_ZIP = "ACcompactado.zip";
    public static final String FILENAME_HASH = "hashsha512.txt";
    public static final Path FULL_PATH_FOLDER_SIGNER = Paths.get(PATH_HOME_USER, FOLDER_SIGNER);
    public static final Path FULL_PATH_ZIP = Paths.get(PATH_HOME_USER, FOLDER_SIGNER, "ACcompactado.zip");
    public static final Path FULL_PATH_HASH = Paths.get(PATH_HOME_USER, FOLDER_SIGNER, "hashsha512.txt");
    private static final Logger LOGGER = LoggerFactory.getLogger(ICPBrasilUserHomeProviderCA.class);
    private static final MessagesBundle chainMessagesBundle = new MessagesBundle();

    public Collection<X509Certificate> getCAs() {
        try {
            LOGGER.debug(chainMessagesBundle.getString("info.ca.home"));
            this.verifyZIPPath();
        }
        catch (IOException e) {
            LOGGER.warn(chainMessagesBundle.getString("error.throwable") + e.getMessage());
        }
        return this.getFromLocalZip(FULL_PATH_ZIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<X509Certificate> getFromLocalZip(Path fileZip) {
        LOGGER.debug(chainMessagesBundle.getString("info.loading.from.file", new Object[]{fileZip.toString()}));
        HashSet<X509Certificate> result = new HashSet();
        long timeBefore = 0L;
        long timeAfter = 0L;
        try {
            timeBefore = System.currentTimeMillis();
            if (!Files.exists(fileZip, new LinkOption[0])) {
                LOGGER.warn(chainMessagesBundle.getString("error.filenotfound.userhome", new Object[]{fileZip.toString()}));
                throw new Exception(chainMessagesBundle.getString("error.filenotfound.userhome", new Object[]{fileZip.toString()}));
            }
            FileInputStream inputStream = new FileInputStream(fileZip.toString());
            result = this.getFromZip(inputStream);
            timeAfter = System.currentTimeMillis();
        }
        catch (Throwable error) {
            try {
                timeAfter = System.currentTimeMillis();
                LOGGER.warn(chainMessagesBundle.getString("error.throwable") + error.getMessage());
            }
            catch (Throwable throwable) {
                LOGGER.debug(chainMessagesBundle.getString("info.time.file.userhome", new Object[]{timeAfter - timeBefore}));
                throw throwable;
            }
            LOGGER.debug(chainMessagesBundle.getString("info.time.file.userhome", new Object[]{timeAfter - timeBefore}));
        }
        LOGGER.debug(chainMessagesBundle.getString("info.time.file.userhome", new Object[]{timeAfter - timeBefore}));
        return result;
    }

    public Path verifyZIPPath() throws IOException {
        Path finalFolder = FULL_PATH_FOLDER_SIGNER;
        if (!Files.isDirectory(finalFolder, new LinkOption[0])) {
            Files.createDirectories(finalFolder, new FileAttribute[0]);
        }
        return finalFolder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<X509Certificate> getFromZip(InputStream zip) throws RuntimeException {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>();
        BufferedInputStream in = new BufferedInputStream(zip);
        ZipInputStream zin = new ZipInputStream(in);
        ZipEntry arquivoInterno = null;
        try {
            while ((arquivoInterno = zin.getNextEntry()) != null) {
                try {
                    if (arquivoInterno.isDirectory()) continue;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] b = new byte[512];
                    int len = 0;
                    while ((len = zin.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                    ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
                    out.close();
                    X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(is);
                    is.close();
                    result.add(certificate);
                }
                catch (CertificateException error) {
                    LOGGER.warn(chainMessagesBundle.getString("error.invalid.certificate"));
                }
            }
            return result;
        }
        catch (IOException error) {
            LOGGER.error(chainMessagesBundle.getString("error.stream") + "\n" + error.getMessage());
            throw new RuntimeException(chainMessagesBundle.getString("error.stream"), error);
        }
    }

    public String getName() {
        return chainMessagesBundle.getString("info.provider.name.userhome", new Object[]{FULL_PATH_ZIP});
    }
}

