/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.xml.icpb;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.policy.engine.exception.PolicyException;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLSignaturePolicy;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLSignerAlgConstraint;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLSignerRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPolicyValidator {
    private Document LPAXML = null;
    private Document xsp = null;
    private static MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLPolicyValidator.class);
    private final ConfigurationRepo config = ConfigurationRepo.getInstance();
    private XMLSignaturePolicy xmlSignaturePolicy = new XMLSignaturePolicy();
    public static final String XAdESv1_3_2 = "http://uri.etsi.org/01903/v1.3.2#";

    public XMLPolicyValidator(Document xsp) {
        this.xsp = xsp;
    }

    public boolean validate() {
        Date lpaNextUpdateDate;
        boolean valid = false;
        this.getXmlSignaturePolicy().setPolicyIssuerName(this.xsp.getElementsByTagName("pa:PolicyIssuerName").item(0).getTextContent());
        this.getXmlSignaturePolicy().setIdentifier(this.xsp.getElementsByTagName("XAdES:Identifier").item(0).getTextContent());
        this.getXmlSignaturePolicy().setFieldOfApplication(this.xsp.getElementsByTagName("pa:FieldOfApplication").item(0).getTextContent());
        NodeList paSignerRules = this.xsp.getElementsByTagName("pa:SignerRules");
        XMLSignerRules xmlSignerRules = new XMLSignerRules();
        for (int i = 0; i < paSignerRules.getLength(); ++i) {
            Element signerRule = (Element)paSignerRules.item(i);
            NodeList signerRuleNodeList = signerRule.getChildNodes();
            for (int j = 0; j < signerRuleNodeList.getLength(); ++j) {
                Element signerRuleChild = (Element)signerRuleNodeList.item(j);
                String typeOfProperties = signerRuleChild.getNodeName();
                NodeList signerRuleChildNodeList = signerRuleChild.getChildNodes();
                for (int k = 0; k < signerRuleChildNodeList.getLength(); ++k) {
                    if (typeOfProperties.equalsIgnoreCase("pa:MandatedSignedQProperties")) {
                        xmlSignerRules.getMandatedSignedQProperties().add(signerRuleChildNodeList.item(k).getTextContent());
                    }
                    if (!typeOfProperties.equalsIgnoreCase("pa:MandatedUnsignedQProperties")) continue;
                    xmlSignerRules.getMandatedUnsignedQProperties().add(signerRuleChildNodeList.item(k).getTextContent());
                }
            }
        }
        this.getXmlSignaturePolicy().setXmlSignerRules(xmlSignerRules);
        NodeList algorithmConstraints = this.xsp.getElementsByTagName("pa:SignerAlgConstraints");
        for (int i = 0; i < algorithmConstraints.getLength(); ++i) {
            Element algorithmConstraintElement = (Element)algorithmConstraints.item(i);
            NodeList algorithmConstraintNodeList = algorithmConstraintElement.getChildNodes();
            for (int j = 0; j < algorithmConstraintNodeList.getLength(); ++j) {
                Element algAndLength = (Element)algorithmConstraintNodeList.item(j);
                NodeList algAndLengthNodeList = algAndLength.getChildNodes();
                XMLSignerAlgConstraint xmlSignerAlgConstraint = new XMLSignerAlgConstraint();
                for (int k = 0; k < algAndLengthNodeList.getLength(); ++k) {
                    Node childNode = algAndLengthNodeList.item(k);
                    if (childNode.getNodeName().equalsIgnoreCase("pa:AlgId")) {
                        xmlSignerAlgConstraint.setAlgId(childNode.getTextContent());
                    }
                    if (!childNode.getNodeName().equalsIgnoreCase("pa:MinKeyLength")) continue;
                    xmlSignerAlgConstraint.setMinKeyLength(childNode.getTextContent());
                }
                this.getXmlSignaturePolicy().getXmlSignerAlgConstraintList().add(xmlSignerAlgConstraint);
            }
        }
        String xspNotBefore = this.xsp.getElementsByTagName("pa:NotBefore").item(0).getTextContent();
        String xspNotAfter = this.xsp.getElementsByTagName("pa:NotAfter").item(0).getTextContent();
        String xspDateOfIssue = this.xsp.getElementsByTagName("pa:DateOfIssue").item(0).getTextContent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Date xspNotBeforeDate = null;
        Date xspNotAfterDate = null;
        try {
            this.getXmlSignaturePolicy().setDateOfIssue(sdf.parse(xspDateOfIssue));
            xspNotBeforeDate = sdf.parse(xspNotBefore);
            this.getXmlSignaturePolicy().setNotBefore(xspNotBeforeDate);
            xspNotAfterDate = sdf.parse(xspNotAfter);
            this.getXmlSignaturePolicy().setNotAfter(xspNotAfterDate);
        }
        catch (ParseException e) {
            LOGGER.error(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
            throw new PolicyException(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
        }
        Date actualDate = new GregorianCalendar().getTime();
        if (actualDate.before(xspNotBeforeDate) || actualDate.after(xspNotAfterDate)) {
            LOGGER.error(policyMessagesBundle.getString("error.policy.valid.period", sdf.format(xspNotBeforeDate), sdf.format(xspNotAfterDate)));
            throw new PolicyException(policyMessagesBundle.getString("error.policy.valid.period", sdf.format(xspNotBeforeDate), sdf.format(xspNotAfterDate)));
        }
        PolicyFactory factory = PolicyFactory.getInstance();
        Document tempLPAXML = factory.loadLPAXAdES();
        this.setLPAXML(tempLPAXML);
        String lpaNextUpdate = tempLPAXML.getElementsByTagName("lpa:NextUpdate").item(0).getTextContent();
        try {
            lpaNextUpdateDate = sdf.parse(lpaNextUpdate);
        }
        catch (ParseException e) {
            LOGGER.error(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
            throw new PolicyException(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
        }
        if (actualDate.after(lpaNextUpdateDate)) {
            LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(lpaNextUpdateDate)));
            LOGGER.debug(policyMessagesBundle.getString("info.lpa.load.local", this.config.getLpaPath()));
            tempLPAXML = factory.loadLPAXAdESLocal();
            if (tempLPAXML != null) {
                lpaNextUpdate = tempLPAXML.getElementsByTagName("lpa:NextUpdate").item(0).getTextContent();
                try {
                    lpaNextUpdateDate = sdf.parse(lpaNextUpdate);
                }
                catch (ParseException e) {
                    LOGGER.error(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
                    throw new PolicyException(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
                }
                if (actualDate.after(lpaNextUpdateDate)) {
                    LOGGER.warn(policyMessagesBundle.getString("error.policy.local.not.updated", this.config.getLpaPath() + "LPA_XAdES.xml", sdf.format(lpaNextUpdateDate)));
                    tempLPAXML = factory.loadLPAXAdESUrl();
                    if (tempLPAXML != null) {
                        lpaNextUpdate = tempLPAXML.getElementsByTagName("lpa:NextUpdate").item(0).getTextContent();
                        try {
                            lpaNextUpdateDate = sdf.parse(lpaNextUpdate);
                        }
                        catch (ParseException e) {
                            LOGGER.error(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
                            throw new PolicyException(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
                        }
                        if (actualDate.after(lpaNextUpdateDate)) {
                            LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(lpaNextUpdateDate)));
                        } else {
                            this.setLPAXML(tempLPAXML);
                        }
                    }
                } else {
                    this.setLPAXML(tempLPAXML);
                }
            } else {
                tempLPAXML = factory.loadLPAXAdESUrl();
                if (tempLPAXML != null) {
                    lpaNextUpdate = tempLPAXML.getElementsByTagName("lpa:NextUpdate").item(0).getTextContent();
                    try {
                        lpaNextUpdateDate = sdf.parse(lpaNextUpdate);
                    }
                    catch (ParseException e) {
                        LOGGER.error(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
                        throw new PolicyException(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
                    }
                    if (actualDate.after(lpaNextUpdateDate)) {
                        LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(lpaNextUpdateDate)));
                    } else {
                        this.setLPAXML(tempLPAXML);
                    }
                } else {
                    LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.found"));
                }
            }
        }
        Element policyIdentifier = (Element)this.xsp.getElementsByTagName("XAdES:Identifier").item(0);
        String textPolicyIdentifier = policyIdentifier.getTextContent();
        NodeList listPolicyInfo = this.LPAXML.getElementsByTagName("lpa:PolicyInfo");
        if (listPolicyInfo.getLength() > 0) {
            for (int i = 0; i < listPolicyInfo.getLength(); ++i) {
                Element elementPolicyInfo = (Element)listPolicyInfo.item(i);
                NodeList policyInfochildNodeList = elementPolicyInfo.getChildNodes();
                for (int j = 0; j < policyInfochildNodeList.getLength(); ++j) {
                    Element elementPolicyInfochild = (Element)policyInfochildNodeList.item(j);
                    Date policyRevogationDate = null;
                    if (elementPolicyInfochild.getNodeName().equalsIgnoreCase("lpa:RevocationDate")) {
                        try {
                            policyRevogationDate = sdf.parse(elementPolicyInfochild.getTextContent());
                        }
                        catch (ParseException e) {
                            LOGGER.error(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
                            throw new PolicyException(policyMessagesBundle.getString("error.date.parser", e.getMessage()));
                        }
                    }
                    String textPolicyOID = "";
                    if (elementPolicyInfochild.getNodeName().equalsIgnoreCase("lpa:policyOIDurn") || elementPolicyInfochild.getNodeName().equalsIgnoreCase("lpa:policyOID")) {
                        textPolicyOID = elementPolicyInfochild.getTextContent();
                    }
                    if (!textPolicyOID.equalsIgnoreCase(textPolicyIdentifier)) continue;
                    if (policyRevogationDate != null) {
                        LOGGER.error(policyMessagesBundle.getString("error.policy.revocated", sdf.format(policyRevogationDate)));
                        throw new PolicyException(policyMessagesBundle.getString("error.policy.revocated", sdf.format(policyRevogationDate)));
                    }
                    valid = true;
                }
            }
        }
        return valid;
    }

    private void setLPAXML(Document lPAXML) {
        this.LPAXML = lPAXML;
    }

    public XMLSignaturePolicy getXmlSignaturePolicy() {
        return this.xmlSignaturePolicy;
    }
}

