/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.etsi;

import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.etsi.AlgorithmConstraints;

public class AlgorithmConstraintSet
extends ASN1Object {
    private AlgorithmConstraints signerAlgorithmConstraints;
    private AlgorithmConstraints eeCertAlgorithmConstraints;
    private AlgorithmConstraints caCertAlgorithmConstraints;
    private AlgorithmConstraints aaCertAlgorithmConstraints;
    private AlgorithmConstraints tsaCertAlgorithmConstraints;

    public AlgorithmConstraints getSignerAlgorithmConstraints() {
        return this.signerAlgorithmConstraints;
    }

    public void setSignerAlgorithmConstraints(AlgorithmConstraints signerAlgorithmConstraints) {
        this.signerAlgorithmConstraints = signerAlgorithmConstraints;
    }

    public AlgorithmConstraints getEeCertAlgorithmConstraints() {
        return this.eeCertAlgorithmConstraints;
    }

    public void setEeCertAlgorithmConstraints(AlgorithmConstraints eeCertAlgorithmConstraints) {
        this.eeCertAlgorithmConstraints = eeCertAlgorithmConstraints;
    }

    public AlgorithmConstraints getCaCertAlgorithmConstraints() {
        return this.caCertAlgorithmConstraints;
    }

    public void setCaCertAlgorithmConstraints(AlgorithmConstraints caCertAlgorithmConstraints) {
        this.caCertAlgorithmConstraints = caCertAlgorithmConstraints;
    }

    public AlgorithmConstraints getAaCertAlgorithmConstraints() {
        return this.aaCertAlgorithmConstraints;
    }

    public void setAaCertAlgorithmConstraints(AlgorithmConstraints aaCertAlgorithmConstraints) {
        this.aaCertAlgorithmConstraints = aaCertAlgorithmConstraints;
    }

    public AlgorithmConstraints getTsaCertAlgorithmConstraints() {
        return this.tsaCertAlgorithmConstraints;
    }

    public void setTsaCertAlgorithmConstraints(AlgorithmConstraints tsaCertAlgorithmConstraints) {
        this.tsaCertAlgorithmConstraints = tsaCertAlgorithmConstraints;
    }

    @Override
    public void parse(ASN1Primitive derObject) {
        ASN1Sequence derSequence = ASN1Object.getDERSequence(derObject);
        int total = derSequence.size();
        if (total > 0) {
            block7: for (int i = 0; i < total; ++i) {
                ASN1Primitive object = derSequence.getObjectAt(i).toASN1Primitive();
                if (!(object instanceof DERTaggedObject)) continue;
                DERTaggedObject derTaggedObject = (DERTaggedObject)object;
                TAG tag = TAG.getTag(derTaggedObject.getTagNo());
                switch (tag) {
                    case signerAlgorithmConstraints: {
                        this.signerAlgorithmConstraints = new AlgorithmConstraints();
                        this.signerAlgorithmConstraints.parse(object);
                        continue block7;
                    }
                    case eeCertAlgorithmConstraints: {
                        this.eeCertAlgorithmConstraints = new AlgorithmConstraints();
                        this.eeCertAlgorithmConstraints.parse(object);
                        continue block7;
                    }
                    case caCertAlgorithmConstraints: {
                        this.caCertAlgorithmConstraints = new AlgorithmConstraints();
                        this.caCertAlgorithmConstraints.parse(object);
                        continue block7;
                    }
                    case aaCertAlgorithmConstraints: {
                        this.aaCertAlgorithmConstraints = new AlgorithmConstraints();
                        this.aaCertAlgorithmConstraints.parse(object);
                        continue block7;
                    }
                    case tsaCertAlgorithmConstraints: {
                        this.tsaCertAlgorithmConstraints = new AlgorithmConstraints();
                        this.tsaCertAlgorithmConstraints.parse(object);
                        continue block7;
                    }
                }
            }
        }
    }

    public static enum TAG {
        signerAlgorithmConstraints(0),
        eeCertAlgorithmConstraints(1),
        caCertAlgorithmConstraints(2),
        aaCertAlgorithmConstraints(3),
        tsaCertAlgorithmConstraints(4);

        private int value;

        private TAG(int value) {
            this.value = value;
        }

        public static TAG getTag(int value) {
            for (TAG tag : TAG.values()) {
                if (tag.value != value) continue;
                return tag;
            }
            return null;
        }
    }
}

