/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.etsi;

import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.etsi.AlgorithmConstraintSet;
import org.demoiselle.signer.policy.engine.asn1.etsi.AttributeTrustCondition;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignPolExtensions;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignerAndVerifierRules;
import org.demoiselle.signer.policy.engine.asn1.etsi.SigningCertTrustCondition;
import org.demoiselle.signer.policy.engine.asn1.etsi.TimestampTrustCondition;

public class CommonRules
extends ASN1Object {
    private SignerAndVerifierRules signerAndVeriferRules;
    private SigningCertTrustCondition signingCertTrustCondition;
    private TimestampTrustCondition timeStampTrustCondition;
    private AttributeTrustCondition attributeTrustCondition;
    private AlgorithmConstraintSet algorithmConstraintSet;
    private SignPolExtensions signPolExtensions;

    public SignerAndVerifierRules getSignerAndVeriferRules() {
        return this.signerAndVeriferRules;
    }

    public void setSignerAndVeriferRules(SignerAndVerifierRules signerAndVeriferRules) {
        this.signerAndVeriferRules = signerAndVeriferRules;
    }

    public SigningCertTrustCondition getSigningCertTrustCondition() {
        return this.signingCertTrustCondition;
    }

    public void setSigningCertTrustCondition(SigningCertTrustCondition signingCertTrustCondition) {
        this.signingCertTrustCondition = signingCertTrustCondition;
    }

    public TimestampTrustCondition getTimeStampTrustCondition() {
        return this.timeStampTrustCondition;
    }

    public void setTimeStampTrustCondition(TimestampTrustCondition timeStampTrustCondition) {
        this.timeStampTrustCondition = timeStampTrustCondition;
    }

    public AttributeTrustCondition getAttributeTrustCondition() {
        return this.attributeTrustCondition;
    }

    public void setAttributeTrustCondition(AttributeTrustCondition attributeTrustCondition) {
        this.attributeTrustCondition = attributeTrustCondition;
    }

    public AlgorithmConstraintSet getAlgorithmConstraintSet() {
        return this.algorithmConstraintSet;
    }

    public void setAlgorithmConstraintSet(AlgorithmConstraintSet algorithmConstraintSet) {
        this.algorithmConstraintSet = algorithmConstraintSet;
    }

    public SignPolExtensions getSignPolExtensions() {
        return this.signPolExtensions;
    }

    public void setSignPolExtensions(SignPolExtensions signPolExtensions) {
        this.signPolExtensions = signPolExtensions;
    }

    @Override
    public void parse(ASN1Primitive derObject) {
        ASN1Sequence derSequence = ASN1Object.getDERSequence(derObject);
        int total = derSequence.size();
        if (total > 0) {
            block8: for (int i = 0; i < total; ++i) {
                ASN1Primitive object = derSequence.getObjectAt(i).toASN1Primitive();
                if (!(object instanceof DERTaggedObject)) continue;
                DERTaggedObject derTaggedObject = (DERTaggedObject)object;
                TAG tag = TAG.getTag(derTaggedObject.getTagNo());
                switch (tag) {
                    case signerAndVeriferRules: {
                        this.signerAndVeriferRules = new SignerAndVerifierRules();
                        this.signerAndVeriferRules.parse(object);
                        continue block8;
                    }
                    case signingCertTrustCondition: {
                        this.signingCertTrustCondition = new SigningCertTrustCondition();
                        this.signingCertTrustCondition.parse(object);
                        continue block8;
                    }
                    case timeStampTrustCondition: {
                        this.timeStampTrustCondition = new TimestampTrustCondition();
                        this.timeStampTrustCondition.parse(object);
                        continue block8;
                    }
                    case attributeTrustCondition: {
                        this.attributeTrustCondition = new AttributeTrustCondition();
                        this.attributeTrustCondition.parse(object);
                        continue block8;
                    }
                    case algorithmConstraintSet: {
                        this.algorithmConstraintSet = new AlgorithmConstraintSet();
                        this.algorithmConstraintSet.parse(object);
                        continue block8;
                    }
                    case signPolExtensions: {
                        this.signPolExtensions = new SignPolExtensions();
                        this.signPolExtensions.parse(object);
                        continue block8;
                    }
                }
            }
        }
    }

    static enum TAG {
        signerAndVeriferRules(0),
        signingCertTrustCondition(1),
        timeStampTrustCondition(2),
        attributeTrustCondition(3),
        algorithmConstraintSet(4),
        signPolExtensions(5);

        private final int value;

        private TAG(int value) {
            this.value = value;
        }

        public static TAG getTag(int value) {
            for (TAG tag : TAG.values()) {
                if (tag.value != value) continue;
                return tag;
            }
            return null;
        }
    }
}

