/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.etsi;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.etsi.ObjectIdentifier;
import org.demoiselle.signer.policy.engine.asn1.etsi.OctetString;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;

public class PolicyIssuerName
extends ASN1Object {
    private Map<ObjectIdentifier, String> issuerNames;
    private String issuerName;
    private static MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");

    @Override
    public void parse(ASN1Primitive primitive) {
        DLSequence sequence;
        ASN1Encodable asn1Encodable;
        if (primitive instanceof DLSequence && (asn1Encodable = (sequence = (DLSequence)primitive).getObjectAt(0)) instanceof DERTaggedObject) {
            DERTaggedObject derTaggedObject = (DERTaggedObject)asn1Encodable;
            ASN1Primitive object = derTaggedObject.getObject();
            if (object instanceof DEROctetString) {
                OctetString octetString = new OctetString();
                octetString.parse(object);
                this.issuerName = octetString.getValueUTF8();
            } else if (object instanceof DERSequence) {
                DERSequence sequence2 = (DERSequence)object;
                for (int i = 0; i < sequence2.size(); ++i) {
                    DERSet set;
                    ASN1Encodable object2;
                    ASN1Encodable obj = sequence2.getObjectAt(i);
                    if (!(obj instanceof DERSet) || !((object2 = (set = (DERSet)obj).getObjectAt(0)) instanceof DERSequence)) continue;
                    DERSequence sequence3 = (DERSequence)object2;
                    ObjectIdentifier objectIdendifier = new ObjectIdentifier();
                    objectIdendifier.parse(sequence3.getObjectAt(0).toASN1Primitive());
                    String name = null;
                    ASN1Encodable object3 = sequence3.getObjectAt(1);
                    if (object3 instanceof DERPrintableString) {
                        name = ((DERPrintableString)object3).getString();
                    } else if (object3 instanceof DERUTF8String) {
                        name = ((DERUTF8String)object3).getString();
                    } else {
                        System.out.println(policyMessagesBundle.getString("error.not.recognized.object", object3.getClass(), object3.toString()));
                    }
                    if (this.issuerNames == null) {
                        this.issuerNames = new HashMap<ObjectIdentifier, String>();
                    }
                    this.issuerNames.put(objectIdendifier, name);
                }
            }
        }
    }

    public Map<ObjectIdentifier, String> getIssuerNames() {
        return this.issuerNames;
    }

    public void setIssuerNames(Map<ObjectIdentifier, String> issuerNames) {
        this.issuerNames = issuerNames;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public String toString() {
        if (this.issuerName != null) {
            return this.issuerName;
        }
        String result = "";
        if (this.issuerNames != null && !this.issuerNames.isEmpty()) {
            for (ObjectIdentifier oid : this.issuerNames.keySet()) {
                result = result + oid.getValue() + "=" + this.issuerNames.get(oid) + ",";
            }
            return result.substring(0, result.length() - 1);
        }
        return null;
    }
}

