/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.etsi;

import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.etsi.CMSAttrs;
import org.demoiselle.signer.policy.engine.asn1.etsi.CertInfoReq;
import org.demoiselle.signer.policy.engine.asn1.etsi.CertRefReq;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignPolExtensions;

public class SignerRules
extends ASN1Object {
    private Boolean externalSignedData = null;
    private CMSAttrs mandatedSignedAttr;
    private CMSAttrs mandatedUnsignedAttr;
    private CertRefReq mandatedCertificateRef = CertRefReq.signerOnly;
    private CertInfoReq mandatedCertificateInfo = CertInfoReq.none;
    private SignPolExtensions signPolExtensions;

    public Boolean getExternalSignedData() {
        return this.externalSignedData;
    }

    public void setExternalSignedData(Boolean externalSignedData) {
        this.externalSignedData = externalSignedData;
    }

    public CMSAttrs getMandatedSignedAttr() {
        return this.mandatedSignedAttr;
    }

    public void setMandatedSignedAttr(CMSAttrs mandatedSignedAttr) {
        this.mandatedSignedAttr = mandatedSignedAttr;
    }

    public CMSAttrs getMandatedUnsignedAttr() {
        return this.mandatedUnsignedAttr;
    }

    public void setMandatedUnsignedAttr(CMSAttrs mandatedUnsignedAttr) {
        this.mandatedUnsignedAttr = mandatedUnsignedAttr;
    }

    public CertRefReq getMandatedCertificateRef() {
        return this.mandatedCertificateRef;
    }

    public void setMandatedCertificateRef(CertRefReq mandatedCertificateRef) {
        this.mandatedCertificateRef = mandatedCertificateRef;
    }

    public CertInfoReq getMandatedCertificateInfo() {
        return this.mandatedCertificateInfo;
    }

    public void setMandatedCertificateInfo(CertInfoReq mandatedCertificateInfo) {
        this.mandatedCertificateInfo = mandatedCertificateInfo;
    }

    public SignPolExtensions getSignPolExtensions() {
        return this.signPolExtensions;
    }

    public void setSignPolExtensions(SignPolExtensions signPolExtensions) {
        this.signPolExtensions = signPolExtensions;
    }

    @Override
    public void parse(ASN1Primitive primitive) {
        ASN1Encodable object;
        int i;
        ASN1Sequence derSequence = ASN1Object.getDERSequence(primitive);
        int total = derSequence.size();
        if (total > 0) {
            block5: for (i = 0; i < total; ++i) {
                object = derSequence.getObjectAt(i).toASN1Primitive();
                if (!(object instanceof DERTaggedObject)) continue;
                DERTaggedObject derTaggedObject = (DERTaggedObject)object;
                TAG tag = TAG.getTag(derTaggedObject.getTagNo());
                switch (tag) {
                    case mandatedCertificateRef: {
                        this.mandatedCertificateRef = CertRefReq.parse((ASN1Primitive)object);
                        continue block5;
                    }
                    case mandatedCertificateInfo: {
                        this.mandatedCertificateInfo = CertInfoReq.parse((ASN1Primitive)object);
                        continue block5;
                    }
                    case signPolExtensions: {
                        this.signPolExtensions = new SignPolExtensions();
                        this.signPolExtensions.parse((ASN1Primitive)object);
                        continue block5;
                    }
                }
            }
        }
        if (!((object = derSequence.getObjectAt(i = 0)) instanceof DERSequence)) {
            if (object instanceof ASN1Boolean) {
                this.externalSignedData = ((ASN1Boolean)object).isTrue();
            }
            ++i;
        }
        this.mandatedSignedAttr = new CMSAttrs();
        this.mandatedSignedAttr.parse(derSequence.getObjectAt(i).toASN1Primitive());
        this.mandatedUnsignedAttr = new CMSAttrs();
        this.mandatedUnsignedAttr.parse(derSequence.getObjectAt(++i).toASN1Primitive());
    }

    static enum TAG {
        mandatedCertificateRef(0),
        mandatedCertificateInfo(1),
        signPolExtensions(2);

        private int value;

        private TAG(int value) {
            this.value = value;
        }

        public static TAG getTag(int value) {
            for (TAG tag : TAG.values()) {
                if (tag.value != value) continue;
                return tag;
            }
            return null;
        }
    }
}

