/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.etsi;

import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.etsi.CertRevReq;
import org.demoiselle.signer.policy.engine.asn1.etsi.CertificateTrustTrees;
import org.demoiselle.signer.policy.engine.asn1.etsi.DeltaTime;
import org.demoiselle.signer.policy.engine.asn1.etsi.NameConstraints;

public class TimestampTrustCondition
extends ASN1Object {
    private CertificateTrustTrees ttsCertificateTrustTrees;
    private CertRevReq ttsRevReq;
    private NameConstraints ttsNameConstraints;
    private DeltaTime cautionPeriod;
    private DeltaTime signatureTimestampDelay;

    public CertificateTrustTrees getTtsCertificateTrustTrees() {
        return this.ttsCertificateTrustTrees;
    }

    public void setTtsCertificateTrustTrees(CertificateTrustTrees ttsCertificateTrustTrees) {
        this.ttsCertificateTrustTrees = ttsCertificateTrustTrees;
    }

    public CertRevReq getTtsRevReq() {
        return this.ttsRevReq;
    }

    public void setTtsRevReq(CertRevReq ttsRevReq) {
        this.ttsRevReq = ttsRevReq;
    }

    public NameConstraints getTtsNameConstraints() {
        return this.ttsNameConstraints;
    }

    public void setTtsNameConstraints(NameConstraints ttsNameConstraints) {
        this.ttsNameConstraints = ttsNameConstraints;
    }

    public DeltaTime getCautionPeriod() {
        return this.cautionPeriod;
    }

    public void setCautionPeriod(DeltaTime cautionPeriod) {
        this.cautionPeriod = cautionPeriod;
    }

    public DeltaTime getSignatureTimestampDelay() {
        return this.signatureTimestampDelay;
    }

    public void setSignatureTimestampDelay(DeltaTime signatureTimestampDelay) {
        this.signatureTimestampDelay = signatureTimestampDelay;
    }

    @Override
    public void parse(ASN1Primitive derObject) {
        ASN1Sequence derSequence = ASN1Object.getDERSequence(derObject);
        int total = derSequence.size();
        if (total > 0) {
            block7: for (int i = 0; i < total; ++i) {
                ASN1Primitive object = derSequence.getObjectAt(i).toASN1Primitive();
                if (!(object instanceof DERTaggedObject)) continue;
                DERTaggedObject derTaggedObject = (DERTaggedObject)object;
                TAG tag = TAG.getTag(derTaggedObject.getTagNo());
                switch (tag) {
                    case ttsCertificateTrustTrees: {
                        this.ttsCertificateTrustTrees = new CertificateTrustTrees();
                        this.ttsCertificateTrustTrees.parse(object);
                        continue block7;
                    }
                    case ttsRevReq: {
                        this.ttsRevReq = new CertRevReq();
                        this.ttsRevReq.parse(object);
                        continue block7;
                    }
                    case ttsNameConstraints: {
                        this.ttsNameConstraints = new NameConstraints();
                        this.ttsNameConstraints.parse(object);
                        continue block7;
                    }
                    case cautionPeriod: {
                        this.cautionPeriod = new DeltaTime();
                        this.cautionPeriod.parse(object);
                        continue block7;
                    }
                    case signatureTimestampDelay: {
                        this.signatureTimestampDelay = new DeltaTime();
                        this.signatureTimestampDelay.parse(object);
                        continue block7;
                    }
                }
            }
        }
    }

    static enum TAG {
        ttsCertificateTrustTrees(0),
        ttsRevReq(1),
        ttsNameConstraints(2),
        cautionPeriod(3),
        signatureTimestampDelay(4);

        int value;

        private TAG(int value) {
            this.value = value;
        }

        public static TAG getTag(int value) {
            for (TAG tag : TAG.values()) {
                if (tag.value != value) continue;
                return tag;
            }
            return null;
        }
    }
}

