/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.icpb;

import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.icpb.PolicyInfo;
import org.demoiselle.signer.policy.engine.asn1.icpb.Time;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;

public class LPA
extends ASN1Object {
    private Collection<PolicyInfo> policyInfos;
    private Time nextUpdate;
    private static MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");

    public Collection<PolicyInfo> getPolicyInfos() {
        return this.policyInfos;
    }

    public void setPolicyInfos(Collection<PolicyInfo> policyInfos) {
        this.policyInfos = policyInfos;
    }

    public Time getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(Time nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    @Override
    public void parse(ASN1Primitive derObject) {
        ASN1Sequence sequence = ASN1Object.getDERSequence(derObject);
        ASN1Primitive policyInfos = sequence.getObjectAt(0).toASN1Primitive();
        DLSequence policyInfosSequence = (DLSequence)policyInfos;
        if (policyInfosSequence != null && policyInfosSequence.size() > 0) {
            this.policyInfos = new ArrayList<PolicyInfo>();
            for (int i = 0; i < policyInfosSequence.size(); ++i) {
                PolicyInfo policyInfo = new PolicyInfo();
                policyInfo.parse(policyInfosSequence.getObjectAt(i).toASN1Primitive());
                this.policyInfos.add(policyInfo);
            }
        }
        this.nextUpdate = new Time();
        this.nextUpdate.parse(sequence.getObjectAt(1).toASN1Primitive());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("===================================================").append("\n");
        builder.append(policyMessagesBundle.getString("text.next.update")).append(this.getNextUpdate().getTime()).append("\n");
        builder.append(policyMessagesBundle.getString("text.quantity")).append(this.getPolicyInfos().size()).append("\n");
        builder.append("===================================================").append("\n");
        for (PolicyInfo policyInfo : this.getPolicyInfos()) {
            builder.append(policyMessagesBundle.getString("text.name")).append(policyInfo.getPolicyName()).append("\n");
            builder.append(policyMessagesBundle.getString("text.uri")).append(policyInfo.getPoliciesURI()).append("\n");
            builder.append(policyMessagesBundle.getString("text.application")).append(policyInfo.getFieldOfApplication()).append("\n");
            builder.append(policyMessagesBundle.getString("text.valid")).append(policyInfo.getSigningPeriod()).append("\n");
            builder.append(policyMessagesBundle.getString("text.status"));
            Time revocationDate = policyInfo.getRevocationDate();
            if (revocationDate != null) {
                builder.append(policyMessagesBundle.getString("text.repealed")).append("\n");
                builder.append(policyMessagesBundle.getString("text.revocation.date")).append(revocationDate != null ? revocationDate.getTime() : policyMessagesBundle.getString("text.revocation.no.date")).append("\n");
            } else {
                builder.append(policyMessagesBundle.getString("text.still.valid")).append("\n");
            }
            builder.append("\t===================================================").append("\n");
        }
        return builder.toString();
    }
}

