/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.icpb.v2;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.policy.engine.asn1.GeneralizedTime;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA;
import org.demoiselle.signer.policy.engine.asn1.icpb.v2.PolicyInfo;
import org.demoiselle.signer.policy.engine.exception.PolicyException;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyValidator {
    private static MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyValidator.class);
    private final ConfigurationRepo config = ConfigurationRepo.getInstance();
    private SignaturePolicy sp;
    private String policyName;
    private LPA listOfPolicies;

    public PolicyValidator(SignaturePolicy sp, String policyName) {
        this.sp = sp;
        this.policyName = policyName;
    }

    public boolean validate() {
        try {
            boolean valid = false;
            Date dateNotBefore = this.sp.getSignPolicyInfo().getSignatureValidationPolicy().getSigningPeriod().getNotBefore().getDate();
            Date dateNotAfter = this.sp.getSignPolicyInfo().getSignatureValidationPolicy().getSigningPeriod().getNotAfter().getDate();
            Date actualDate = new GregorianCalendar().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy - hh:mm:ss");
            if (actualDate.before(dateNotBefore) || actualDate.after(dateNotAfter)) {
                LOGGER.error(policyMessagesBundle.getString("error.policy.valid.period", sdf.format(dateNotBefore), sdf.format(dateNotAfter)));
                throw new PolicyException(policyMessagesBundle.getString("error.policy.valid.period", sdf.format(dateNotBefore), sdf.format(dateNotAfter)));
            }
            PolicyFactory factory = PolicyFactory.getInstance();
            LPA tempListOfPolicies = null;
            if (this.policyName.contains("CADES")) {
                this.listOfPolicies = tempListOfPolicies = factory.loadLPACAdES();
                Date nextUpdate = tempListOfPolicies.getNextUpdate().getDate();
                if (actualDate.after(nextUpdate)) {
                    LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(nextUpdate)));
                    LOGGER.debug(policyMessagesBundle.getString("info.lpa.load.local", this.config.getLpaPath()));
                    tempListOfPolicies = factory.loadLPACAdESLocal();
                    if (tempListOfPolicies != null) {
                        nextUpdate = tempListOfPolicies.getNextUpdate().getDate();
                        if (actualDate.after(nextUpdate)) {
                            LOGGER.warn(policyMessagesBundle.getString("error.policy.local.not.updated", this.config.getLpaPath() + "LPA_CAdES.der", sdf.format(nextUpdate)));
                            tempListOfPolicies = factory.loadLPACAdESUrl();
                            if (tempListOfPolicies != null) {
                                nextUpdate = tempListOfPolicies.getNextUpdate().getDate();
                                if (actualDate.after(nextUpdate)) {
                                    LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(nextUpdate)));
                                } else {
                                    this.listOfPolicies = tempListOfPolicies;
                                }
                            }
                        } else {
                            this.listOfPolicies = tempListOfPolicies;
                        }
                    } else {
                        tempListOfPolicies = factory.loadLPACAdESUrl();
                        if (tempListOfPolicies != null) {
                            nextUpdate = tempListOfPolicies.getNextUpdate().getDate();
                            if (actualDate.after(nextUpdate)) {
                                LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(nextUpdate)));
                            } else {
                                this.listOfPolicies = tempListOfPolicies;
                            }
                        } else {
                            LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.found"));
                        }
                    }
                }
                for (PolicyInfo policyInfo : this.listOfPolicies.getPolicyInfos()) {
                    if (!policyInfo.getPolicyOID().getValue().contentEquals(this.sp.getSignPolicyInfo().getSignPolicyIdentifier().getValue())) continue;
                    valid = true;
                    GeneralizedTime revocationDate = policyInfo.getRevocationDate();
                    if (revocationDate == null) continue;
                    LOGGER.error(policyMessagesBundle.getString("error.policy.revocated", sdf.format(revocationDate.getDate())));
                    throw new PolicyException(policyMessagesBundle.getString("error.policy.revocated", sdf.format(revocationDate.getDate())));
                }
            } else if (this.policyName.contains("PADES")) {
                this.listOfPolicies = tempListOfPolicies = factory.loadLPAPAdES();
                Date nextUpdate = tempListOfPolicies.getNextUpdate().getDate();
                if (actualDate.after(nextUpdate)) {
                    LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(nextUpdate)));
                    LOGGER.info(policyMessagesBundle.getString("info.lpa.load.local"));
                    tempListOfPolicies = factory.loadLPAPAdESLocal();
                    if (tempListOfPolicies != null) {
                        nextUpdate = tempListOfPolicies.getNextUpdate().getDate();
                        if (actualDate.after(nextUpdate)) {
                            LOGGER.warn(policyMessagesBundle.getString("error.policy.local.not.updated", this.config.getLpaPath() + "LPA_PAdES.der", sdf.format(nextUpdate)));
                            tempListOfPolicies = factory.loadLPAPAdESUrl();
                            if (tempListOfPolicies != null) {
                                nextUpdate = tempListOfPolicies.getNextUpdate().getDate();
                                if (actualDate.after(nextUpdate)) {
                                    LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(nextUpdate)));
                                } else {
                                    this.listOfPolicies = tempListOfPolicies;
                                }
                            }
                        } else {
                            this.listOfPolicies = tempListOfPolicies;
                        }
                    } else {
                        tempListOfPolicies = factory.loadLPAPAdESUrl();
                        if (tempListOfPolicies != null) {
                            nextUpdate = tempListOfPolicies.getNextUpdate().getDate();
                            if (actualDate.after(nextUpdate)) {
                                LOGGER.warn(policyMessagesBundle.getString("error.policy.not.updated", sdf.format(nextUpdate)));
                            } else {
                                this.listOfPolicies = tempListOfPolicies;
                            }
                        } else {
                            LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.found"));
                        }
                    }
                }
                for (PolicyInfo policyInfo : this.listOfPolicies.getPolicyInfos()) {
                    if (!policyInfo.getPolicyOID().getValue().contentEquals(this.sp.getSignPolicyInfo().getSignPolicyIdentifier().getValue())) continue;
                    valid = true;
                    GeneralizedTime revocationDate = policyInfo.getRevocationDate();
                    if (revocationDate == null) continue;
                    LOGGER.error(policyMessagesBundle.getString("error.policy.revocated", sdf.format(revocationDate.getDate())));
                    throw new PolicyException(policyMessagesBundle.getString("error.policy.revocated", sdf.format(revocationDate.getDate())));
                }
            } else {
                if (this.policyName.contains("XADES")) {
                    LOGGER.error(policyMessagesBundle.getString("error.policy.not.recognized", this.policyName));
                    throw new PolicyException(policyMessagesBundle.getString("error.policy.not.recognized", this.policyName));
                }
                LOGGER.error(policyMessagesBundle.getString("error.policy.not.recognized", this.policyName));
                throw new PolicyException(policyMessagesBundle.getString("error.policy.not.recognized", this.policyName));
            }
            return valid;
        }
        catch (Exception ex) {
            throw new PolicyException(ex.getMessage(), ex);
        }
    }
}

