/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.factory;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Downloads;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.engine.asn1.icpb.LPA;
import org.demoiselle.signer.policy.engine.repository.LPARepository;
import org.demoiselle.signer.policy.engine.repository.PolicyEngineConfig;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;
import org.demoiselle.signer.policy.engine.util.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PolicyFactory {
    public static final PolicyFactory instance = new PolicyFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyFactory.class);
    private static final MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");

    public static PolicyFactory getInstance() {
        return instance;
    }

    public SignaturePolicy loadPolicy(Policies policy) {
        SignaturePolicy signaturePolicy = new SignaturePolicy();
        InputStream is = this.getClass().getResourceAsStream(policy.getFile());
        ASN1Primitive primitive = this.readANS1FromStream(is);
        signaturePolicy.parse(primitive);
        signaturePolicy.setSignPolicyURI(policy.getUrl());
        return signaturePolicy;
    }

    public Document loadXMLPolicy(Policies policy) {
        try {
            InputStream is = this.getClass().getResourceAsStream(policy.getFile());
            return XMLUtil.loadXMLDocument(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public LPA loadLPA() {
        LPA listaPoliticaAssinatura = new LPA();
        InputStream is = this.getClass().getResourceAsStream(ListOfSubscriptionPolicies.LPAV1.getFile());
        ASN1Primitive primitive = this.readANS1FromStream(is);
        listaPoliticaAssinatura.parse(primitive);
        return listaPoliticaAssinatura;
    }

    @Deprecated
    public org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLPAv2() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        InputStream is = this.getClass().getResourceAsStream(ListOfSubscriptionPolicies.LPAV2.getFile());
        ASN1Primitive primitive = this.readANS1FromStream(is);
        listaPoliticaAssinatura.parse(primitive);
        return listaPoliticaAssinatura;
    }

    public org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLPACAdES() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        InputStream is = this.getClass().getResourceAsStream(ListOfSubscriptionPolicies.CAdES.getFile());
        ASN1Primitive primitive = this.readANS1FromStream(is);
        listaPoliticaAssinatura.parse(primitive);
        return listaPoliticaAssinatura;
    }

    public org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLPAPAdES() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        InputStream is = this.getClass().getResourceAsStream(ListOfSubscriptionPolicies.PAdES.getFile());
        ASN1Primitive primitive = this.readANS1FromStream(is);
        listaPoliticaAssinatura.parse(primitive);
        return listaPoliticaAssinatura;
    }

    public Document loadLPAXAdES() {
        InputStream is = this.getClass().getResourceAsStream(ListOfSubscriptionPolicies.XAdES.getFile());
        return XMLUtil.loadXMLDocument(is);
    }

    public org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLPACAdESLocal() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        try {
            ConfigurationRepo config = ConfigurationRepo.getInstance();
            Path pathLPA = Paths.get(config.getLpaPath(), "LPA_CAdES.der");
            LOGGER.debug(policyMessagesBundle.getString("info.lpa.load.local", pathLPA));
            FileInputStream is = new FileInputStream(pathLPA.toString());
            ASN1Primitive primitive = this.readANS1FromStream(is);
            listaPoliticaAssinatura.parse(primitive);
            return listaPoliticaAssinatura;
        }
        catch (Exception e) {
            LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.found", "LPA_CAdES.der"));
            listaPoliticaAssinatura = this.loadLPACAdESUrl();
            if (listaPoliticaAssinatura != null) {
                return listaPoliticaAssinatura;
            }
            LOGGER.error(policyMessagesBundle.getString("error.lpa.not.found", "LPA_CAdES.der"));
            throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.found", "LPA_CAdES.der"));
        }
    }

    public org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLPAPAdESLocal() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        try {
            ConfigurationRepo config = ConfigurationRepo.getInstance();
            Path pathLPA = Paths.get(config.getLpaPath(), "LPA_PAdES.der");
            LOGGER.debug(policyMessagesBundle.getString("info.lpa.load.local", pathLPA));
            FileInputStream is = new FileInputStream(pathLPA.toString());
            ASN1Primitive primitive = this.readANS1FromStream(is);
            listaPoliticaAssinatura.parse(primitive);
            return listaPoliticaAssinatura;
        }
        catch (Exception e) {
            LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.found", "LPA_PAdES.der"));
            listaPoliticaAssinatura = this.loadLPAPAdESUrl();
            if (listaPoliticaAssinatura != null) {
                return listaPoliticaAssinatura;
            }
            LOGGER.error(policyMessagesBundle.getString("error.lpa.not.found", "LPA_PAdES.der"));
            throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.found", "LPA_PAdES.der"));
        }
    }

    public Document loadLPAXAdESLocal() {
        try {
            ConfigurationRepo config = ConfigurationRepo.getInstance();
            Path pathLPA = Paths.get(config.getLpaPath(), "LPA_XAdES.xml");
            LOGGER.debug(policyMessagesBundle.getString("info.lpa.load.local", pathLPA));
            FileInputStream is = new FileInputStream(pathLPA.toString());
            Document localLPAXML = XMLUtil.loadXMLDocument(is);
            return localLPAXML;
        }
        catch (Exception e) {
            LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.found", "LPA_XAdES.xml"));
            Document localLPAXML = this.loadLPAXAdESUrl();
            if (localLPAXML != null) {
                return localLPAXML;
            }
            LOGGER.error(policyMessagesBundle.getString("error.lpa.not.found", "LPA_XAdES.xml"));
            throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.found", "LPA_XAdES.xml"));
        }
    }

    public org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLPACAdESUrl() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        String conURL = ListOfSubscriptionPolicies.CAdES_ITI_URL.getUrl();
        try {
            LOGGER.info(policyMessagesBundle.getString("info.lpa.load.url", conURL));
            InputStream is = Downloads.getInputStreamFromURL((String)conURL);
            ASN1Primitive primitive = this.readANS1FromStream(is);
            listaPoliticaAssinatura.parse(primitive);
            is.close();
            if (!LPARepository.saveLocalLPA(conURL, "LPA_CAdES.der")) {
                LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.saved", "LPA_CAdES.der"));
                throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            }
        }
        catch (IOException | RuntimeException ex) {
            LOGGER.error(ex.getMessage());
            LOGGER.error(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            listaPoliticaAssinatura = this.loadLocalLPACAdESUrl();
            return listaPoliticaAssinatura;
        }
        return listaPoliticaAssinatura;
    }

    private org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLocalLPACAdESUrl() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        String conURL = ListOfSubscriptionPolicies.CAdES_LOCAL_URL.getUrl();
        try {
            LOGGER.info(policyMessagesBundle.getString("info.lpa.load.url", conURL));
            InputStream is = Downloads.getInputStreamFromURL((String)conURL);
            ASN1Primitive primitive = this.readANS1FromStream(is);
            listaPoliticaAssinatura.parse(primitive);
            is.close();
            if (!LPARepository.saveLocalLPA(conURL, "LPA_CAdES.der")) {
                LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.saved", "LPA_CAdES.der"));
                throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            }
        }
        catch (RuntimeException ex1) {
            LOGGER.error(ex1.getMessage());
            throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
        }
        catch (IOException e1) {
            LOGGER.error(e1.getMessage());
            throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
        }
        return listaPoliticaAssinatura;
    }

    public org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLPAPAdESUrl() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        String conURL = ListOfSubscriptionPolicies.PAdES_ITI_URL.getUrl();
        try {
            LOGGER.info(policyMessagesBundle.getString("info.lpa.load.url", conURL));
            InputStream is = Downloads.getInputStreamFromURL((String)conURL);
            ASN1Primitive primitive = this.readANS1FromStream(is);
            is.close();
            if (!LPARepository.saveLocalLPA(conURL, "LPA_PAdES.der")) {
                LOGGER.error(policyMessagesBundle.getString("error.lpa.not.saved", "LPA_PAdES.der"));
                throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            }
            listaPoliticaAssinatura.parse(primitive);
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(e.getMessage());
            LOGGER.error(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            listaPoliticaAssinatura = this.loadLocalLPAPAdESUrl();
            return listaPoliticaAssinatura;
        }
        return listaPoliticaAssinatura;
    }

    private org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA loadLocalLPAPAdESUrl() {
        org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA listaPoliticaAssinatura = new org.demoiselle.signer.policy.engine.asn1.icpb.v2.LPA();
        String conURL = ListOfSubscriptionPolicies.PAdES_LOCAL_URL.getUrl();
        try {
            LOGGER.info(policyMessagesBundle.getString("info.lpa.load.url", conURL));
            InputStream is = Downloads.getInputStreamFromURL((String)conURL);
            ASN1Primitive primitive = this.readANS1FromStream(is);
            is.close();
            if (!LPARepository.saveLocalLPA(conURL, "LPA_PAdES.der")) {
                LOGGER.error(policyMessagesBundle.getString("error.lpa.not.saved", "LPA_PAdES.der"));
                throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            }
            listaPoliticaAssinatura.parse(primitive);
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
        }
        return listaPoliticaAssinatura;
    }

    public Document loadLPAXAdESUrl() {
        Document localLPAXML;
        String conURL = ListOfSubscriptionPolicies.XAdES_ITI_URL.getUrl();
        try {
            LOGGER.info(policyMessagesBundle.getString("info.lpa.load.url", conURL));
            InputStream is = Downloads.getInputStreamFromURL((String)conURL);
            localLPAXML = XMLUtil.loadXMLDocument(is);
            is.close();
            if (!LPARepository.saveLocalLPA(conURL, "LPA_XAdES.xml")) {
                LOGGER.warn(policyMessagesBundle.getString("error.lpa.not.saved", "LPA_XAdES.xml"));
                throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            }
        }
        catch (IOException | RuntimeException ex) {
            LOGGER.error(ex.getMessage());
            LOGGER.error(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            Document localLPAXML2 = this.loadLocalLPAXAdESUrl();
            return localLPAXML2;
        }
        return localLPAXML;
    }

    public Document loadLocalLPAXAdESUrl() {
        Document localLPAXML;
        String conURL = ListOfSubscriptionPolicies.XAdES_LOCAL_URL.getUrl();
        try {
            LOGGER.info(policyMessagesBundle.getString("info.lpa.load.url", conURL));
            InputStream is = Downloads.getInputStreamFromURL((String)conURL);
            localLPAXML = XMLUtil.loadXMLDocument(is);
            is.close();
            if (!LPARepository.saveLocalLPA(conURL, "LPA_XAdES.xml")) {
                LOGGER.error(policyMessagesBundle.getString("error.lpa.not.saved", "LPA_XAdES.xml"));
                throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException(policyMessagesBundle.getString("error.lpa.not.saved", conURL));
        }
        return localLPAXML;
    }

    private ASN1Primitive readANS1FromStream(InputStream is) {
        ASN1InputStream asn1is = new ASN1InputStream(is);
        ASN1Primitive primitive = null;
        try {
            primitive = asn1is.readObject();
        }
        catch (IOException error) {
            LOGGER.error("Error reading stream.", (Throwable)error);
            throw new RuntimeException(error);
        }
        finally {
            try {
                asn1is.close();
            }
            catch (IOException error) {
                LOGGER.error(error.getMessage());
                throw new RuntimeException(error);
            }
        }
        return primitive;
    }

    public static enum ListOfSubscriptionPolicies {
        LPAV1("/org/demoiselle/signer/policy/engine/artifacts/LPA.der"),
        LPAV2("/org/demoiselle/signer/policy/engine/artifacts/LPAv2.der"),
        CAdES("/org/demoiselle/signer/policy/engine/artifacts/LPA_CAdES.der"),
        XAdES("/org/demoiselle/signer/policy/engine/artifacts/LPA_XAdES.xml"),
        PAdES("/org/demoiselle/signer/policy/engine/artifacts/LPA_PAdES.der"),
        LPAV1_URL("http://politicas.icpbrasil.gov.br/LPA.der"),
        LPAV2_URL("http://politicas.icpbrasil.gov.br/LPAv2.der"),
        CAdES_ITI_URL(PolicyEngineConfig.getInstance().getUrl_iti_lpa_cades()),
        CAdES_ITI_URL_SHA(PolicyEngineConfig.getInstance().getUrl_iti_lpa_cades_sha()),
        XAdES_ITI_URL(PolicyEngineConfig.getInstance().getUrl_iti_lpa_xades()),
        XAdES_ITI_URL_SHA(PolicyEngineConfig.getInstance().getUrl_iti_lpa_xades_sha()),
        PAdES_ITI_URL(PolicyEngineConfig.getInstance().getUrl_iti_lpa_pades()),
        PAdES_ITI_URL_SHA(PolicyEngineConfig.getInstance().getUrl_iti_lpa_pades_sha()),
        CAdES_LOCAL_URL(PolicyEngineConfig.getInstance().getUrl_local_lpa_cades()),
        CAdES_LOCAL_URL_SHA(PolicyEngineConfig.getInstance().getUrl_local_lpa_cades_sha()),
        XAdES_LOCAL_URL(PolicyEngineConfig.getInstance().getUrl_local_lpa_xades()),
        XAdES_LOCAL_URL_SHA(PolicyEngineConfig.getInstance().getUrl_local_lpa_xades_sha()),
        PAdES_LOCAL_URL(PolicyEngineConfig.getInstance().getUrl_local_lpa_pades()),
        PAdES_LOCAL_URL_SHA(PolicyEngineConfig.getInstance().getUrl_local_lpa_pades_sha());

        private final String url;
        private final String file;

        private ListOfSubscriptionPolicies(String file) {
            this.file = file;
            this.url = file;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static enum Policies {
        AD_RB_CADES_1_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB.der", "http://politicas.icpbrasil.gov.br/PA_AD_RB.der"),
        AD_RB_CADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v1_1.der"),
        AD_RB_CADES_2_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v2_0.der", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v2_0.der"),
        AD_RB_CADES_2_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v2_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v2_1.der"),
        AD_RB_CADES_2_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v2_2.der", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v2_2.der"),
        AD_RB_CADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v2_3.der", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v2_3.der"),
        AD_RT_CADES_1_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT.der", "http://politicas.icpbrasil.gov.br/PA_AD_RT.der"),
        AD_RT_CADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v1_1.der"),
        AD_RT_CADES_2_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v2_0.der", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v2_0.der"),
        AD_RT_CADES_2_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v2_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v2_1.der"),
        AD_RT_CADES_2_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v2_2.der", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v2_2.der"),
        AD_RT_CADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v2_3.der", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v2_3.der"),
        AD_RV_CADES_1_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV.der", "http://politicas.icpbrasil.gov.br/PA_AD_RV.der"),
        AD_RV_CADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RV_v1_1.der"),
        AD_RV_CADES_2_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV_v2_0.der", "http://politicas.icpbrasil.gov.br/PA_AD_RV_v2_0.der"),
        AD_RV_CADES_2_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV_v2_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RV_v2_1.der"),
        AD_RV_CADES_2_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV_v2_2.der", "http://politicas.icpbrasil.gov.br/PA_AD_RV_v2_2.der"),
        AD_RV_CADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV_v2_3.der", "http://politicas.icpbrasil.gov.br/PA_AD_RV_v2_3.der"),
        AD_RC_CADES_1_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RC.der", "http://politicas.icpbrasil.gov.br/PA_AD_RC.der"),
        AD_RC_CADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RC_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RC_v1_1.der"),
        AD_RC_CADES_2_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RC_v2_0.der", "http://politicas.icpbrasil.gov.br/PA_AD_RC_v2_0.der"),
        AD_RC_CADES_2_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RC_v2_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RC_v2_1.der"),
        AD_RC_CADES_2_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RC_v2_2.der", "http://politicas.icpbrasil.gov.br/PA_AD_RC_v2_2.der"),
        AD_RC_CADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RC_v2_3.der", "http://politicas.icpbrasil.gov.br/PA_AD_RC_v2_3.der"),
        AD_RA_CADES_1_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA.der", "http://politicas.icpbrasil.gov.br/PA_AD_RA.der"),
        AD_RA_CADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v1_1.der"),
        AD_RA_CADES_1_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v1_2.der", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v1_2.der"),
        AD_RA_CADES_2_0("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v2_0.der", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v2_0.der"),
        AD_RA_CADES_2_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v2_1.der", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v2_1.der"),
        AD_RA_CADES_2_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v2_2.der", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v2_2.der"),
        AD_RA_CADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v2_3.der", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v2_3.der"),
        AD_RA_CADES_2_4("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v2_4.der", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v2_4.der"),
        AD_RB_XADES_2_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v2_1.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v2_1.xml"),
        AD_RB_XADES_2_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v2_2.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v2_2.xml"),
        AD_RB_XADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v2_3.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v2_3.xml"),
        AD_RB_XADES_2_4("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RB_v2_4.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RB_v2_4.xml"),
        AD_RT_XADES_2_1("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v2_1.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v2_1.xml"),
        AD_RT_XADES_2_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v2_2.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v2_2.xml"),
        AD_RT_XADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v2_3.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v2_3.xml"),
        AD_RT_XADES_2_4("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RT_v2_4.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RT_v2_4.xml"),
        AD_RV_XADES_2_2("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV_v2_2.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RV_v2_2.xml"),
        AD_RV_XADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV_v2_3.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RV_v2_3.xml"),
        AD_RV_XADES_2_4("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RV_v2_4.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RV_v2_4.xml"),
        AD_RC_XADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RC_v2_3.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RC_v2_3.xml"),
        AD_RC_XADES_2_4("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RC_v2_4.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RC_v2_4.xml"),
        AD_RA_XADES_2_3("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v2_3.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v2_3.xml"),
        AD_RA_XADES_2_4("/org/demoiselle/signer/policy/engine/artifacts/PA_AD_RA_v2_4.xml", "http://politicas.icpbrasil.gov.br/PA_AD_RA_v2_4.xml"),
        AD_RB_PADES_1_0("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RB_v1_0.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RB_v1_0.der"),
        AD_RB_PADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RB_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RB_v1_1.der"),
        AD_RT_PADES_1_0("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RT_v1_0.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RT_v1_0.der"),
        AD_RT_PADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RT_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RT_v1_1.der"),
        AD_RC_PADES_1_0("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RC_v1_0.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RC_v1_0.der"),
        AD_RC_PADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RC_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RC_v1_1.der"),
        AD_RC_PADES_1_2("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RC_v1_2.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RC_v1_2.der"),
        AD_RA_PADES_1_1("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RA_v1_1.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RA_v1_1.der"),
        AD_RA_PADES_1_2("/org/demoiselle/signer/policy/engine/artifacts/PA_PAdES_AD_RA_v1_2.der", "http://politicas.icpbrasil.gov.br/PA_PAdES_AD_RA_v1_2.der");

        private final String file;
        private final String url;

        private Policies(String file, String url) {
            this.file = file;
            this.url = url;
        }

        public String getFile() {
            return this.file;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

