/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.repository;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Downloads;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LPARepository {
    private static MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");
    private static final Logger LOGGER = LoggerFactory.getLogger(LPARepository.class);

    public static boolean saveLocalLPA(String urlConLPA, String lpaName) {
        ConfigurationRepo config = ConfigurationRepo.getInstance();
        try {
            if (config.isOnlineLPA()) {
                return true;
            }
            Path pathLPA = Paths.get(config.getLpaPath(), new String[0]);
            Path pathLPAFile = Paths.get(config.getLpaPath(), lpaName);
            LOGGER.info(policyMessagesBundle.getString("info.lpa.url.download", urlConLPA));
            if (!Files.isDirectory(pathLPA, new LinkOption[0])) {
                LOGGER.info(policyMessagesBundle.getString("warn.lpa.dir.not.found", pathLPA));
                Files.createDirectories(pathLPA, new FileAttribute[0]);
            }
            LOGGER.info(policyMessagesBundle.getString("info.lpa.url.download", urlConLPA));
            InputStream is = Downloads.getInputStreamFromURL((String)urlConLPA);
            Files.copy(is, pathLPAFile, StandardCopyOption.REPLACE_EXISTING);
            is.close();
            return true;
        }
        catch (FileNotFoundException e) {
            LOGGER.error(policyMessagesBundle.getString("error.lpa.local.exception", e.getMessage()));
            config.setOnlineLPA(true);
            return true;
        }
        catch (IOException e) {
            LOGGER.error(policyMessagesBundle.getString("error.lpa.local.exception", e.getMessage()));
            config.setOnlineLPA(true);
            return true;
        }
    }
}

