/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.icpb.v2;

import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.GeneralizedTime;
import org.demoiselle.signer.policy.engine.asn1.icpb.v2.PolicyInfo;
import org.demoiselle.signer.policy.engine.asn1.icpb.v2.Version;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;

public class LPA
extends ASN1Object {
    private Version version;
    private Collection<PolicyInfo> policyInfos;
    private GeneralizedTime nextUpdate;
    private static MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Collection<PolicyInfo> getPolicyInfos() {
        return this.policyInfos;
    }

    public void setPolicyInfos(Collection<PolicyInfo> policyInfos) {
        this.policyInfos = policyInfos;
    }

    public GeneralizedTime getNextUpdate() {
        return this.nextUpdate;
    }

    public void setNextUpdate(GeneralizedTime nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    @Override
    public void parse(ASN1Primitive derObject) {
        ASN1Primitive policyInfos;
        DLSequence policyInfosSequence;
        ASN1Sequence sequence = ASN1Object.getDERSequence(derObject);
        ASN1Primitive firstObject = sequence.getObjectAt(0).toASN1Primitive();
        this.version = new Version();
        int indice = 0;
        if (firstObject instanceof ASN1Integer) {
            this.version.parse(firstObject);
            ++indice;
        }
        if ((policyInfosSequence = (DLSequence)(policyInfos = sequence.getObjectAt(indice).toASN1Primitive())) != null && policyInfosSequence.size() > 0) {
            this.policyInfos = new ArrayList<PolicyInfo>();
            for (int i = 0; i < policyInfosSequence.size(); ++i) {
                PolicyInfo policyInfo = new PolicyInfo();
                policyInfo.parse(policyInfosSequence.getObjectAt(i).toASN1Primitive());
                this.policyInfos.add(policyInfo);
            }
        }
        this.nextUpdate = new GeneralizedTime();
        this.nextUpdate.parse(sequence.getObjectAt(indice + 1).toASN1Primitive());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("===================================================").append("\n");
        builder.append(policyMessagesBundle.getString("text.next.update")).append(this.getNextUpdate().getDate()).append("\n");
        builder.append(policyMessagesBundle.getString("text.quantity")).append(this.getPolicyInfos().size()).append("\n");
        builder.append("===================================================");
        for (PolicyInfo policyInfo : this.getPolicyInfos()) {
            builder.append(policyMessagesBundle.getString("text.valid")).append(policyInfo.getSigningPeriod()).append("\n");
            builder.append(policyMessagesBundle.getString("text.oid")).append(policyInfo.getPolicyOID().getValue()).append("\n");
            builder.append(policyMessagesBundle.getString("text.uri")).append(policyInfo.getPolicyURI()).append("\n");
            builder.append(policyMessagesBundle.getString("text.algo.hash")).append(policyInfo.getPolicyDigest().getHashAlgorithm().getAlgorithm().getId()).append("\n");
            builder.append(policyMessagesBundle.getString("text.hash")).append(policyInfo.getPolicyDigest().getHashValue().toString()).append("\n");
            builder.append(policyMessagesBundle.getString("text.status"));
            GeneralizedTime revocationDate = policyInfo.getRevocationDate();
            if (revocationDate != null) {
                builder.append(policyMessagesBundle.getString("text.repealed")).append("\n");
                builder.append(policyMessagesBundle.getString("text.revocation.date")).append(revocationDate != null ? revocationDate.getDate() : policyMessagesBundle.getString("text.revocation.no.date")).append("\n");
            } else {
                builder.append(policyMessagesBundle.getString("text.still.valid")).append("\n");
            }
            builder.append("\t===================================================").append("\n");
        }
        return builder.toString();
    }
}

