/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.impl;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.SignedAttribute;

public class ContentType
implements SignedAttribute {
    private final ASN1ObjectIdentifier identifier = PKCSObjectIdentifiers.pkcs_9_at_contentType;

    @Override
    public String getOID() {
        return this.identifier.getId();
    }

    @Override
    public Attribute getValue() {
        return new Attribute(this.identifier, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier(contentType.data.getOid())));
    }

    @Override
    public void initialize(PrivateKey privateKey, Certificate[] certificates, byte[] content, SignaturePolicy signaturePolicy, byte[] hash) {
    }

    private static enum contentType {
        data("1.2.840.113549.1.7.1"),
        signedData("1.2.840.113549.1.7.2"),
        envelopedData("1.2.840.113549.1.7.3"),
        signedAndEnvelopedData("1.2.840.113549.1.7.4"),
        digestedData("1.2.840.113549.1.7.5"),
        encryptedData("1.2.840.113549.1.7.6");

        private String oid;

        private contentType(String oid) {
            this.oid = oid;
        }

        public String getOid() {
            return this.oid;
        }
    }
}

