/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades;

import org.demoiselle.signer.cryptography.DigestAlgorithmEnum;

public enum SignerAlgorithmEnum {
    SHA1withDSA("SHA1withDSA", DigestAlgorithmEnum.SHA_1.getAlgorithm(), "1.3.14.3.2.26", "DSA", "1.2.840.10040.4.3"),
    SHA1withRSA("SHA1withRSA", DigestAlgorithmEnum.SHA_1.getAlgorithm(), "1.3.14.3.2.26", "RSA", "1.2.840.113549.1.1.1"),
    SHA256withRSA("SHA256withRSA", DigestAlgorithmEnum.SHA_256.getAlgorithm(), "2.16.840.1.101.3.4.2.1", "RSA", "1.2.840.113549.1.1.1"),
    SHA256withECDSA("SHA256withECDSA", DigestAlgorithmEnum.SHA_256.getAlgorithm(), "2.16.840.1.101.3.4.2.1", "ECDSA", "1.0.14888.3.0.4"),
    SHA512withRSA("SHA512withRSA", DigestAlgorithmEnum.SHA_512.getAlgorithm(), "2.16.840.1.101.3.4.2.3", "RSA", "1.2.840.113549.1.1.1"),
    SHA512withECDSA("SHA512withECDSA", DigestAlgorithmEnum.SHA_512.getAlgorithm(), "2.16.840.1.101.3.4.2.3", "ECDSA", "1.0.14888.3.0.4");

    public static SignerAlgorithmEnum DEFAULT;
    private String algorithm;
    private String algorithmHash;
    private String OIDAlgorithmHash;
    private String algorithmCipher;
    private String OIDAlgorithmCipher;

    private SignerAlgorithmEnum(String algorithm, String algorithmHash, String OIDAlgorithmHash, String algorithmCipher, String OIDAlgorithmCipher) {
        this.algorithm = algorithm;
        this.algorithmHash = algorithmHash;
        this.algorithmCipher = algorithmCipher;
        this.OIDAlgorithmCipher = OIDAlgorithmCipher;
        this.OIDAlgorithmHash = OIDAlgorithmHash;
    }

    public String getOIDAlgorithmHash() {
        return this.OIDAlgorithmHash;
    }

    public String getOIDAlgorithmCipher() {
        return this.OIDAlgorithmCipher;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmHash() {
        return this.algorithmHash;
    }

    public String getAlgorithmCipher() {
        return this.algorithmCipher;
    }

    public static SignerAlgorithmEnum getSignerAlgorithmEnum(String algorithm) {
        for (SignerAlgorithmEnum value : SignerAlgorithmEnum.values()) {
            if (!value.getAlgorithm().equalsIgnoreCase(algorithm)) continue;
            return value;
        }
        return null;
    }

    public static SignerAlgorithmEnum getSignerOIDAlgorithmHashEnum(String OIDalgorithm) {
        for (SignerAlgorithmEnum value : SignerAlgorithmEnum.values()) {
            if (!value.getOIDAlgorithmHash().equalsIgnoreCase(OIDalgorithm)) continue;
            return value;
        }
        return null;
    }

    static {
        DEFAULT = SHA512withRSA;
    }
}

