/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.factory;

import java.util.ServiceLoader;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.SignedOrUnsignedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeFactory {
    private static final Logger logger = LoggerFactory.getLogger(AttributeFactory.class);
    public static final AttributeFactory instance = new AttributeFactory();
    private static MessagesBundle cadesMessagesBundle = new MessagesBundle();

    public static AttributeFactory getInstance() {
        return instance;
    }

    public SignedOrUnsignedAttribute factory(String attributeOID) {
        ServiceLoader<SignedOrUnsignedAttribute> loader = ServiceLoader.load(SignedOrUnsignedAttribute.class);
        if (loader != null) {
            for (SignedOrUnsignedAttribute attribute : loader) {
                if (!attribute.getOID().equalsIgnoreCase(attributeOID)) continue;
                return attribute;
            }
        } else {
            logger.error(cadesMessagesBundle.getString("info.oid.not.found", new Object[]{attributeOID}));
        }
        return null;
    }
}

