/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.impl;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.demoiselle.signer.cryptography.Digest;
import org.demoiselle.signer.cryptography.DigestAlgorithmEnum;
import org.demoiselle.signer.cryptography.factory.DigestFactory;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.UnsignedAttribute;

public class CertificateRefs
implements UnsignedAttribute {
    private final ASN1ObjectIdentifier identifier = PKCSObjectIdentifiers.id_aa_ets_certificateRefs;
    private Certificate[] certificates = null;

    @Override
    public void initialize(PrivateKey privateKey, Certificate[] certificates, byte[] content, SignaturePolicy signaturePolicy, byte[] hash) {
        this.certificates = certificates;
    }

    @Override
    public String getOID() {
        return this.identifier.getId();
    }

    @Override
    public Attribute getValue() throws SignerException {
        try {
            int chainSize = this.certificates.length - 1;
            OtherCertID[] arrayOtherCertID = new OtherCertID[chainSize];
            for (int i = 1; i <= chainSize; ++i) {
                OtherCertID otherCertID;
                X509Certificate issuerCert = null;
                X509Certificate cert = (X509Certificate)this.certificates[i];
                issuerCert = i < chainSize ? (X509Certificate)this.certificates[i + 1] : (X509Certificate)this.certificates[i];
                Digest digest = DigestFactory.getInstance().factoryDefault();
                digest.setAlgorithm(DigestAlgorithmEnum.SHA_256);
                byte[] certHash = digest.digest(cert.getEncoded());
                X500Name dirName = new JcaX509CertificateHolder(issuerCert).getSubject();
                GeneralName name = new GeneralName(dirName);
                GeneralNames issuer = new GeneralNames(name);
                ASN1Integer serialNumber = new ASN1Integer(cert.getSerialNumber());
                IssuerSerial issuerSerial = new IssuerSerial(issuer, serialNumber);
                AlgorithmIdentifier algId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
                arrayOtherCertID[i - 1] = otherCertID = new OtherCertID(algId, certHash, issuerSerial);
            }
            return new Attribute(this.identifier, (ASN1Set)new DERSet(new ASN1Encodable[]{new DERSequence((ASN1Encodable[])arrayOtherCertID)}));
        }
        catch (CertificateEncodingException e) {
            throw new SignerException(e.getMessage());
        }
    }
}

