/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.impl;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.demoiselle.signer.cryptography.Digest;
import org.demoiselle.signer.cryptography.DigestAlgorithmEnum;
import org.demoiselle.signer.cryptography.factory.DigestFactory;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.SignedAttribute;

public class SigningCertificateV2
implements SignedAttribute {
    private final ASN1ObjectIdentifier identifier = PKCSObjectIdentifiers.id_aa_signingCertificateV2;
    private Certificate[] certificates = null;

    @Override
    public void initialize(PrivateKey privateKey, Certificate[] certificates, byte[] content, SignaturePolicy signaturePolicy, byte[] hash) {
        this.certificates = certificates;
    }

    @Override
    public String getOID() {
        return this.identifier.getId();
    }

    @Override
    public Attribute getValue() throws SignerException {
        try {
            X509Certificate cert = (X509Certificate)this.certificates[0];
            X509Certificate issuerCert = (X509Certificate)this.certificates[1];
            Digest digest = DigestFactory.getInstance().factoryDefault();
            digest.setAlgorithm(DigestAlgorithmEnum.SHA_256);
            byte[] certHash = digest.digest(cert.getEncoded());
            X500Name dirName = new JcaX509CertificateHolder(issuerCert).getSubject();
            GeneralName name = new GeneralName(dirName);
            GeneralNames issuer = new GeneralNames(name);
            ASN1Integer serialNumber = new ASN1Integer(cert.getSerialNumber());
            IssuerSerial issuerSerial = new IssuerSerial(issuer, serialNumber);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
            ESSCertIDv2 essCertIDv2 = new ESSCertIDv2(algId, certHash, issuerSerial);
            org.bouncycastle.asn1.ess.SigningCertificateV2 signingCertificateV2 = new org.bouncycastle.asn1.ess.SigningCertificateV2(essCertIDv2);
            return new Attribute(this.identifier, (ASN1Set)new DERSet((ASN1Encodable)signingCertificateV2));
        }
        catch (CertificateEncodingException ex) {
            throw new SignerException(ex.getMessage());
        }
    }
}

