/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.impl;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSVerifierCertificateNotValidException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.demoiselle.signer.core.CertificateManager;
import org.demoiselle.signer.core.ca.manager.CAManager;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.exception.CertificateRevocationException;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.core.exception.CertificateValidatorException;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.validator.CRLValidator;
import org.demoiselle.signer.core.validator.PeriodValidator;
import org.demoiselle.signer.policy.engine.asn1.etsi.ObjectIdentifier;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.AttachedContentValidation;
import org.demoiselle.signer.policy.impl.cades.SignatureInformations;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.pkcs7.PKCS7Checker;
import org.demoiselle.signer.timestamp.Timestamp;
import org.demoiselle.signer.timestamp.connector.TimeStampOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESChecker
implements PKCS7Checker {
    private static final Logger logger = LoggerFactory.getLogger(CAdESChecker.class);
    private SignaturePolicy signaturePolicy = null;
    private static MessagesBundle cadesMessagesBundle = new MessagesBundle();
    private byte[] hash = null;
    private Map<String, byte[]> hashes = new HashMap<String, byte[]>();
    private boolean checkHash = false;
    private List<SignatureInformations> signaturesInfo = new ArrayList<SignatureInformations>();
    private String policyName;
    private CertificateManager certificateManager;

    private boolean check(byte[] content, byte[] signedData) throws SignerException {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        CMSSignedData cmsSignedData = null;
        try {
            cmsSignedData = content == null ? (this.checkHash ? new CMSSignedData(this.hashes, signedData) : new CMSSignedData(signedData)) : (this.getAttached(signedData, false).getExtractedContent() != null ? new CMSSignedData(signedData) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(content), signedData));
        }
        catch (CMSException ex) {
            logger.error(cadesMessagesBundle.getString("error.invalid.bytes.pkcs7") + ex.getMessage());
            throw new SignerException(cadesMessagesBundle.getString("error.invalid.bytes.pkcs7"), ex);
        }
        int verified = 0;
        Store certStore = cmsSignedData.getCertificates();
        SignerInformationStore signers = cmsSignedData.getSignerInfos();
        Iterator it = signers.getSigners().iterator();
        while (it.hasNext()) {
            SignatureInformations signatureInfo = new SignatureInformations();
            try {
                LinkedList varChain;
                SignerInformation signerInfo = (SignerInformation)it.next();
                SignerInformationStore signerInfoStore = signerInfo.getCounterSignatures();
                if (signerInfoStore.size() > 0) {
                    logger.info(cadesMessagesBundle.getString("info.co.signature", new Object[]{signerInfoStore.size()}));
                }
                Collection certCollection = certStore.getMatches((Selector)signerInfo.getSID());
                Iterator certIt = certCollection.iterator();
                X509CertificateHolder certificateHolder = (X509CertificateHolder)certIt.next();
                X509Certificate varCert = new JcaX509CertificateConverter().getCertificate(certificateHolder);
                CRLValidator cV = new CRLValidator();
                try {
                    cV.validate(varCert);
                }
                catch (CertificateValidatorCRLException cvce) {
                    signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.crl.not.access", new Object[]{cvce.getMessage()}));
                    logger.debug(cadesMessagesBundle.getString("error.crl.not.access", new Object[]{cvce.getMessage()}));
                }
                catch (CertificateRevocationException cre) {
                    signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.crl.not.access", new Object[]{cre.getMessage()}));
                    logger.error(cadesMessagesBundle.getString("error.crl.not.access", new Object[]{cre.getMessage()}));
                }
                PeriodValidator pV = new PeriodValidator();
                try {
                    signatureInfo.setNotAfter(pV.valDate(varCert));
                }
                catch (CertificateValidatorException cve) {
                    signatureInfo.getValidatorWarnins().add(cve.getMessage());
                    logger.error(cve.getMessage());
                }
                try {
                    if (signerInfo.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(certificateHolder))) {
                        logger.info(cadesMessagesBundle.getString("info.signature.valid.seq", new Object[]{++verified}));
                    } else {
                        signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.invalid.signature", new Object[]{"Erro de verifica\u00e7\u00e3o!"}));
                        signatureInfo.setInvalidSignature(true);
                    }
                }
                catch (CMSVerifierCertificateNotValidException e) {
                    signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.invalid.signature", new Object[]{e.getMessage()}));
                    signatureInfo.setInvalidSignature(true);
                }
                logger.debug(cadesMessagesBundle.getString("info.signed.attribute"));
                String varOIDPolicy = PKCSObjectIdentifiers.id_aa_ets_sigPolicyId.getId();
                AttributeTable signedAttributes = signerInfo.getSignedAttributes();
                if (signedAttributes == null || signedAttributes != null && signedAttributes.size() == 0) {
                    signatureInfo.getValidatorWarnins().add(cadesMessagesBundle.getString("error.signed.attribute.table.not.found"));
                    logger.warn(cadesMessagesBundle.getString("error.signed.attribute.table.not.found"));
                } else {
                    Attribute idSigningPolicy = null;
                    idSigningPolicy = signedAttributes.get(new ASN1ObjectIdentifier(varOIDPolicy));
                    if (idSigningPolicy == null) {
                        signatureInfo.getValidatorWarnins().add(cadesMessagesBundle.getString("error.pcks7.attribute.not.found", new Object[]{varOIDPolicy}));
                    } else {
                        Enumeration p = idSigningPolicy.getAttrValues().getObjects();
                        block16: while (p.hasMoreElements()) {
                            String policyOnSignature = p.nextElement().toString();
                            for (PolicyFactory.Policies pv : PolicyFactory.Policies.values()) {
                                if (!policyOnSignature.contains(pv.getUrl())) continue;
                                this.setSignaturePolicy(pv);
                                continue block16;
                            }
                        }
                    }
                }
                Date dataHora = null;
                if (signedAttributes != null) {
                    Attribute attributeContentType = signedAttributes.get(CMSAttributes.contentType);
                    if (attributeContentType == null) {
                        signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.pcks7.attribute.not.found", new Object[]{"ContentType"}));
                        logger.info(cadesMessagesBundle.getString("error.pcks7.attribute.not.found", new Object[]{"ContentType"}));
                        throw new SignerException(cadesMessagesBundle.getString("error.pcks7.attribute.not.found", new Object[]{"ContentType"}));
                    }
                    if (!attributeContentType.getAttrValues().getObjectAt(0).equals(ContentInfo.data)) {
                        signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.content.not.data"));
                        logger.info(cadesMessagesBundle.getString("error.content.not.data"));
                        throw new SignerException(cadesMessagesBundle.getString("error.content.not.data"));
                    }
                    Attribute attributeMessageDigest = signedAttributes.get(CMSAttributes.messageDigest);
                    if (attributeMessageDigest == null) {
                        logger.info(cadesMessagesBundle.getString("error.pcks7.attribute.not.found", new Object[]{"MessageDigest"}));
                        throw new SignerException(cadesMessagesBundle.getString("error.pcks7.attribute.not.found", new Object[]{"MessageDigest"}));
                    }
                    Attribute timeAttribute = signedAttributes.get(CMSAttributes.signingTime);
                    if (timeAttribute != null) {
                        TimeZone.setDefault(null);
                        dataHora = ((ASN1UTCTime)timeAttribute.getAttrValues().getObjectAt(0)).getDate();
                        logger.debug(cadesMessagesBundle.getString("info.date.utc", new Object[]{dataHora}));
                    } else {
                        logger.debug(cadesMessagesBundle.getString("info.date.utc", new Object[]{"N/D"}));
                    }
                }
                if (this.signaturePolicy == null) {
                    signatureInfo.getValidatorWarnins().add(cadesMessagesBundle.getString("error.policy.on.component.not.found", new Object[]{varOIDPolicy}));
                    logger.debug(cadesMessagesBundle.getString("error.policy.on.component.not.found"));
                } else if (this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedSignedAttr().getObjectIdentifiers() != null) {
                    for (Object objectIdentifier : this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedSignedAttr().getObjectIdentifiers()) {
                        String oi = objectIdentifier.getValue();
                        Attribute signedAtt = signedAttributes.get(new ASN1ObjectIdentifier(oi));
                        logger.debug(oi);
                        if (signedAtt != null) continue;
                        logger.debug(cadesMessagesBundle.getString("error.signed.attribute.not.found", new Object[]{oi, this.signaturePolicy.getSignPolicyInfo().getSignPolicyIdentifier().getValue()}));
                        signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.signed.attribute.not.found", new Object[]{oi, this.signaturePolicy.getSignPolicyInfo().getSignPolicyIdentifier().getValue()}));
                    }
                }
                logger.debug(cadesMessagesBundle.getString("info.unsigned.attribute"));
                AttributeTable unsignedAttributes = signerInfo.getUnsignedAttributes();
                if (unsignedAttributes == null || unsignedAttributes != null && unsignedAttributes.size() == 0) {
                    logger.debug(cadesMessagesBundle.getString("error.unsigned.attribute.table.not.found"));
                }
                if (this.signaturePolicy != null && this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedUnsignedAttr().getObjectIdentifiers() != null) {
                    Object objectIdentifier;
                    objectIdentifier = this.signaturePolicy.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedUnsignedAttr().getObjectIdentifiers().iterator();
                    while (objectIdentifier.hasNext()) {
                        ObjectIdentifier objectIdentifier2 = (ObjectIdentifier)objectIdentifier.next();
                        String oi = objectIdentifier2.getValue();
                        Attribute unSignedAtt = unsignedAttributes.get(new ASN1ObjectIdentifier(oi));
                        logger.debug(oi);
                        if (unSignedAtt == null) {
                            logger.debug(cadesMessagesBundle.getString("error.signed.attribute.not.found", new Object[]{oi, this.signaturePolicy.getSignPolicyInfo().getSignPolicyIdentifier().getValue()}));
                            signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.unsigned.attribute.not.found", new Object[]{oi, this.signaturePolicy.getSignPolicyInfo().getSignPolicyIdentifier().getValue()}));
                        }
                        if (oi.equalsIgnoreCase(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.getId())) {
                            try {
                                byte[] varSignature = signerInfo.getSignature();
                                Timestamp varTimeStampSigner = this.validateTimestamp(unSignedAtt, varSignature);
                                signatureInfo.setTimeStampSigner(varTimeStampSigner);
                            }
                            catch (Exception ex) {
                                logger.info(ex.getMessage());
                                signatureInfo.getValidatorErrors().add(ex.getMessage());
                            }
                        }
                        if (!oi.equalsIgnoreCase("1.2.840.113549.1.9.16.2.25")) continue;
                        logger.info("++++++++++  EscTimeStamp ++++++++++++");
                    }
                }
                if ((varChain = (LinkedList)CAManager.getInstance().getCertificateChain(varCert)).size() < 2) {
                    signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.no.ca", new Object[]{varCert.getIssuerDN()}));
                    logger.info(cadesMessagesBundle.getString("error.no.ca", new Object[]{varCert.getIssuerDN()}));
                }
                for (X509Certificate cert : varChain) {
                    BasicCertificate signerCertificate = new BasicCertificate(cert);
                    if (signerCertificate.isCACertificate()) continue;
                    signatureInfo.setIcpBrasilcertificate(signerCertificate);
                }
                signatureInfo.setSignDate(dataHora);
                signatureInfo.setChain(varChain);
                signatureInfo.setSignaturePolicy(this.signaturePolicy);
                this.getSignaturesInfo().add(signatureInfo);
            }
            catch (CertificateException | OperatorCreationException ex) {
                signatureInfo.getValidatorErrors().add(ex.getMessage());
                logger.info(ex.getMessage());
            }
            catch (CMSException ex) {
                if (ex instanceof CMSSignerDigestMismatchException) {
                    if (this.checkHash) {
                        Iterator iterator = cmsSignedData.getDigestAlgorithmIDs().iterator();
                        if (!iterator.hasNext()) continue;
                        AlgorithmIdentifier ai = (AlgorithmIdentifier)iterator.next();
                        signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.signature.mismatch.digest"));
                        logger.info(cadesMessagesBundle.getString("error.signature.mismatch.digest", new Object[]{SignerAlgorithmEnum.getSignerOIDAlgorithmHashEnum(ai.getAlgorithm().getId()).getAlgorithm()}));
                        throw new SignerException(cadesMessagesBundle.getString("error.signature.mismatch.digest", new Object[]{SignerAlgorithmEnum.getSignerOIDAlgorithmHashEnum(ai.getAlgorithm().getId()).getAlgorithm()}), ex);
                    }
                    signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.signature.mismatch"));
                    logger.info(cadesMessagesBundle.getString("error.signature.mismatch"));
                    throw new SignerException(cadesMessagesBundle.getString("error.signature.mismatch"), ex);
                }
                signatureInfo.getValidatorErrors().add(cadesMessagesBundle.getString("error.signature.invalid", new Object[]{ex.getMessage()}));
                logger.info(cadesMessagesBundle.getString("error.signature.invalid", new Object[]{ex.getMessage()}));
                throw new SignerException(cadesMessagesBundle.getString("error.signature.invalid", new Object[]{ex.getMessage()}), ex);
            }
            catch (ParseException e) {
                signatureInfo.getValidatorErrors().add(e.getMessage());
                logger.info(e.getMessage());
            }
        }
        logger.debug(cadesMessagesBundle.getString("info.signature.verified", new Object[]{verified}));
        return true;
    }

    private Timestamp validateTimestamp(Attribute attributeTimeStamp, byte[] varSignature) {
        try {
            TimeStampOperator timeStampOperator = new TimeStampOperator();
            byte[] varTimeStamp = attributeTimeStamp.getAttrValues().getObjectAt(0).toASN1Primitive().getEncoded();
            TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(varTimeStamp));
            Timestamp timeStampSigner = new Timestamp(timeStampToken);
            timeStampOperator.validate(varSignature, varTimeStamp, null);
            return timeStampSigner;
        }
        catch (IOException | CMSException | TSPException | CertificateCoreException e) {
            throw new SignerException(e);
        }
    }

    public byte[] getAttached(byte[] signed) {
        AttachedContentValidation varAttachedContentValidation = this.getAttached(signed, true);
        return varAttachedContentValidation.getExtractedContent();
    }

    @Override
    public AttachedContentValidation getAttached(byte[] signed, boolean validateOnExtract) {
        AttachedContentValidation varAttachedContentValidation = new AttachedContentValidation();
        if (validateOnExtract && this.check(null, signed)) {
            varAttachedContentValidation.setSignaturesInfo(this.getSignaturesInfo());
        }
        CMSSignedData signedData = null;
        try {
            signedData = new CMSSignedData(signed);
        }
        catch (CMSException exception) {
            logger.error(cadesMessagesBundle.getString("error.invalid.bytes.pkcs7") + exception.getMessage());
            throw new SignerException(cadesMessagesBundle.getString("error.invalid.bytes.pkcs7"), exception);
        }
        try {
            CMSTypedData contentProcessable = signedData.getSignedContent();
            if (contentProcessable != null) {
                varAttachedContentValidation.setExtractedContent((byte[])contentProcessable.getContent());
            } else {
                logger.debug(cadesMessagesBundle.getString("info.get.content.empty"));
            }
        }
        catch (Exception exception) {
            logger.error(cadesMessagesBundle.getString("error.get.content.pkcs7") + exception.getMessage());
            throw new SignerException(cadesMessagesBundle.getString("error.get.content.pkcs7"), exception);
        }
        return varAttachedContentValidation;
    }

    @Override
    public List<SignatureInformations> checkAttachedSignature(byte[] signedData) {
        if (this.check(null, signedData)) {
            return this.getSignaturesInfo();
        }
        return null;
    }

    @Override
    public List<SignatureInformations> checkDetachedSignature(byte[] content, byte[] signedData) {
        if (this.check(content, signedData)) {
            return this.getSignaturesInfo();
        }
        return null;
    }

    @Override
    public List<SignatureInformations> checkSignatureByHash(String digestAlgorithmOID, byte[] calculatedHashContent, byte[] signedData) throws SignerException {
        this.checkHash = true;
        this.hashes.put(digestAlgorithmOID, calculatedHashContent);
        this.setHash(calculatedHashContent);
        if (this.check(null, signedData)) {
            return this.getSignaturesInfo();
        }
        return null;
    }

    @Override
    public List<SignatureInformations> checkSignatureByHash(byte[] calculatedHashContent, byte[] signedData) {
        this.checkHash = true;
        this.hashes.put(SignerAlgorithmEnum.SHA256withRSA.getOIDAlgorithmHash(), calculatedHashContent);
        this.hashes.put(SignerAlgorithmEnum.SHA512withRSA.getOIDAlgorithmHash(), calculatedHashContent);
        this.setHash(calculatedHashContent);
        if (this.check(null, signedData)) {
            return this.getSignaturesInfo();
        }
        return null;
    }

    public List<SignatureInformations> checkSignatureByHashes(Map<String, byte[]> hashes, byte[] signedData) throws SignerException {
        this.checkHash = true;
        this.hashes.putAll(hashes);
        if (this.check(null, signedData)) {
            return this.getSignaturesInfo();
        }
        return null;
    }

    private void setSignaturePolicy(PolicyFactory.Policies signaturePolicy) {
        SignaturePolicy sp;
        this.setPolicyName(signaturePolicy.name());
        PolicyFactory policyFactory = PolicyFactory.getInstance();
        this.signaturePolicy = sp = policyFactory.loadPolicy(signaturePolicy);
    }

    @Override
    public List<SignatureInformations> getSignaturesInfo() {
        return this.signaturesInfo;
    }

    public void setSignaturesInfo(List<SignatureInformations> signatureInfo) {
        this.signaturesInfo = signatureInfo;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public CertificateManager getCertificateManager() {
        return this.certificateManager;
    }

    public void setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }
}

