/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.cryptography;

public enum DigestAlgorithmEnum {
    MD5("MD5"),
    SHA_1("SHA-1"),
    SHA_224("SHA224"),
    SHA_256("SHA-256"),
    SHA_384("SHA384"),
    SHA_512("SHA-512"),
    SHA3_224("SHA3-224"),
    SHA3_256("SHA3-256"),
    SHA3_384("SHA3-384"),
    SHA3_512("SHA3-512"),
    SHAKE_128("SHAKE128"),
    SHAKE_256("SHAKE256");

    public static DigestAlgorithmEnum DEFAULT;
    private String algorithm;

    private DigestAlgorithmEnum(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static DigestAlgorithmEnum getDigestAlgorithmEnum(String algorithm) {
        for (DigestAlgorithmEnum value : DigestAlgorithmEnum.values()) {
            if (!value.getAlgorithm().equalsIgnoreCase(algorithm)) continue;
            return value;
        }
        return null;
    }

    static {
        DEFAULT = SHA_256;
    }
}

